#! /usr/bin/python
# Script to apply patches from qt-copy/patches/.
# See README.qt-copy for details.
#
import os
import platform
import re
import subprocess
import sys

verbose = False

def list_patches():
    patches = list()
    rx = re.compile("^[0-9]{4}-.*$")
    for file in os.listdir( "patches" ):
        if rx.match( file ):
            patches.append( file )
            if verbose:
                print "found patch: " + file
    return sorted(patches)

def list_applied_patches():
    patches_applied = list()
    if( os.path.exists( ".applied_patches" ) ):
        f = open( ".applied_patches", "rb" )
        for line in f:
            patches_applied.append( line.strip() )
            if verbose:
                print "patches_applied: " + line.strip()
        f.close()
    return sorted(patches_applied)

def get_patches_to_apply( patches, patches_applied ):
    patches_to_apply = list()
    for patch in patches:
        if patch in patches_applied:
            if verbose:
                print "already applied: " + patch
        else:
            patches_to_apply.append( patch )
    return patches_to_apply

def apply_patches( patches_to_apply ):
    f_applied = open( ".applied_patches", "a" )
    rx = re.compile("^applied: yes.*$")
    for patch in patches_to_apply:
        if verbose:
            print "applying " + patch

        # hack for windows
        fn = os.path.join( "patches", patch )
        f = open( fn, "rb" )
        content = ""
        applied = False
        for line in f:
            if platform.system() == "Windows":
                content += line.replace( "\n", "\r\n" )
            if rx.match( line ):
                applied = True
                if verbose:
                    print patch + " already applied - skipping"
                break
        f.close()
        if applied:
            f_applied.write( patch + "\n" )
            continue

        if platform.system() == "Windows":
            f = open( ".patch_to_apply", "wb" )
            f.write( content )
            f.close()
            fn = ".patch_to_apply"

        if verbose:
            print "Applying " + patch
        cmdstring = "patch -p0 < " + fn
        p = subprocess.Popen( cmdstring, shell = True, stdout = sys.stdout, stderr = sys.stderr )
        if ( p.wait() != 0 ):
            print  "Error executing " + cmdstring
            exit( 2 )
        f_applied.write( patch + "\n" )
    f_applied.close()



if not os.path.exists( "patches" ):
    print  "No patches directory found."
    exit( 1 )

patches = list_patches()
patches_applied = list_applied_patches()
patches_to_apply = get_patches_to_apply( patches, patches_applied )
apply_patches( patches_to_apply )

exit( 0 )
