#     Copyright 2006 Jim Bublitz <jbublitz@nwinternet.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

usageMsg = """
'versionclean' strips versioning information from sip files, and
removes any code that has been versioned out (compared to the value
of 'version' specified in the command line)

  python versionclean.py [-R][-o destination]   version   path
  python versionclean.py [-h]

  where:
    version - the (usually new) version to strip
    (eg KDE_3_80_1)

    path - the path to the directory containing the
    sip files to be reviewed [default]

    or, with -R, the top level sip directory whose
    subdirectories will be scanned
    
    -h   This message
    -o   The output path for the cleaned files. If no output
         path specified, the original files are replaced. If
         destination does not exist, it will be created.

"""

import sys, os, os.path
import getopt

directories = []

opt_one  = True
opt_dest = False

version  = ""
dest     = ""


def oneDirectory (basename):
    modulePath = os.path.join (path, basename)
    if not os.path.isdir (modulePath):
        print "%s is not a directory" % modulePath
        sys.exit (-1)
                
    if opt_dest:
        destpath = os.path.join (dest, basename)
        if not os.path.exists (destpath):
            mkdirs (destpath)
                            
    else:
        destpath = modulePath
    
    files = os.listdir (modulePath)
    files.sort ()
    for file in files:
        if os.path.splitext (file) [1] not in [".sip", ".sip.in"]:
            continue

        srcfile  = os.path.join (modulePath, file)

        m = open (srcfile, "r")

        if not opt_dest:
            destfile = os.path.join (destpath, file) + ".new"
        else:
            destfile = os.path.join (destpath, file)
        
        n = open (destfile, "w")
        
        for line in m:
            if line.startswith ("%If"):
                outputIfBlock (line, m, n)
            else:
                n.write (line)
        
        m.close ()
        n.close ()

        if not opt_dest:
            os.unlink (srcfile)
            os.rename (destfile, srcfile)

        
def allDirectories ():
    if not os.path.isdir (path):
        print "%s is not a directory" % path
        sys.exit (-1)

    files = os.listdir (path)
    files.sort ()
    for file in files:
        if not os.path.isdir (os.path.join (path, file)):
            continue

        oneDirectory (file)

def outputIfBlock (line, m, n):
    if not "-" in line:
        return
       
    if isClosedVersion (line) or isLaterVersion (line):
        skipIfBlock (m)
        return

    endCount = 1
    
    for line in m:
        if line.strip () == "%End":
            endCount -= 1
            if not endCount:
                return
        
        elif line.startswith ("%If"):
            outputIfBlock (line, m, n)
            continue
            
        elif line.startswith ("%"):            
            endCount += 1

        n.write (line)

def skipIfBlock (m):
    endCount = 1
    for line in m:        
        if line.strip () == "%End":
            endCount -= 1
            if not endCount:
                return
            continue
                    
        elif line.startswith ("%"):            
            endCount += 1
        

def isClosedVersion (line):
   
    lp = line.find ("(")
    rp = line.find (")")
      
    if not lp > 0 or not rp > 0 or lp > rp:
        print "**** syntax error *****"
        print line
        sys.exit (-1)

    condition = line [lp + 1:rp]
    versions  = condition.split ("-")
    vhigh     = versions [1].strip ()

    if not vhigh:
        return False

    return vhigh <= version

def isLaterVersion (line):
    
    lp = line.find ("(")
    rp = line.find (")")
      
    if not lp > 0 or not rp > 0 or lp > rp:
        print "**** syntax error *****"
        print line,
        return False

    condition = line [lp + 1:rp]
    versions  = condition.split ("-")
    vlow      = versions [0].strip ()

    if not vlow:
        return False

    return vlow > version

def mkdirs (path):
    dirs = path.split ("/")
    for d in dirs:
        if d == "":
            mkpath = "/"
        else:
            mkpath = os.path.join (mkpath, d)
                        
        if not os.path.exists (mkpath):
            try:
                os.mkdir (mkpath)
            except:
                print "could not create path %s" % arg
                sys.exit (-1)

def usage ():
    print usageMsg
    sys.exit (-1)

def getOptions (argv):
    try:
        optlist, args = getopt.getopt(argv[1:], "ho:R")
    except getopt.GetoptError:
        usage()


    global opt_one
    
    for opt, arg in optlist:
        if opt == "-h":
            usage()
        
        elif opt == "-o":
            mkdirs (arg)    
            global opt_dest, dest
            dest = arg
            opt_dest = True

        elif opt == "-R":
            opt_one  = False
    
    global version

    if len (args) != 2:
        usage ()

    version  = args [0]
    fullpath = args [1]

    return fullpath


if __name__ == "__main__":
    fullpath = getOptions (sys.argv)
    print version, fullpath
    global path
    
    if opt_one:
        path, basename = os.path.split (fullpath)
        oneDirectory (basename)
    else:
        path = fullpath
        allDirectories ()        
