#     Copyright 2007-8 Jim Bublitz <jbublitz@nwinternet.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

class StateInfo(object):
    # this class is used to maintain state information wherever it's needed
    # - parsers, while merging, scoping, etc
    # it mostly provides convenience functions to access various information
    # about the current state
    def __init__ (self):
        self.clear ()

    def clear (self):        
        self.module         = None
        self.filename       = None
        self.ignore         = False
        self.force          = False
        self.scope          = ''
        self.namespaceStack = []
        self.classStack     = []
        self.access         = None
        self.accessStack    = []
        self.versionStack   = [(None, None, None)]
        self.doc            = ""
        self.oldDoc         = ""
        self.inTemplate     = []
        self.inTypedef      = False
        self.lastElement    = []
        self.objectStack    = []
        self.previousObject = None
        self.lexState       = 'variable'
        self.inline         = False
    
    def currentClass (self):
        if not self.classStack:
            return None
        return self.classStack [-1]

    def currentNamespace (self):
        if not self.namespaceStack:
            return None
        return self.namespaceStack [-1]
        
    def currentObject (self):
        if not self.objectStack:
            return None
        return self.objectStack [-1]

    def currentVersion (self):
        if not self.versionStack:
            return None
        return self.versionStack [-1]

    def pushNamespace (self, name, namespaceObj):
        self.namespaceStack.append (name)
        self.pushObject (namespaceObj)
        self.previousObject = namespaceObj
        self.computeScope ()

    def pushClass (self, name, classObj):
        self.classStack.append (name)
        self.pushObject (classObj)
        self.previousObject = classObj
        self.pushAccess (self.access)
        self.computeScope ()

    def pushObject (self, obj):
        self.objectStack.append (obj)

    def pushVersion (self, version):
        self.versionStack.append (version)
        
    def pushAccess (self, access):
        self.accessStack.append (access)
                
    def popNamespace (self, noObj = False):
        name = self.namespaceStack.pop ()
        obj  = self.popObject ()
        self.computeScope ()
        if noObj:
            return name
        else:
            return name, obj
            
    def popClass (self, noObj = False):
        name = self.classStack.pop ()
        obj  = self.popObject ()
        self.computeScope ()
        self.access = self.popAccess ()
        if noObj:
            return name
        else:
            return name, obj

    def popObject (self):
        self.previousObject = self.objectStack.pop ()
        return self.previousObject

    def popAccess (self):        
        return self.accessStack.pop ()
        
    def popVersion (self):
        if self.versionStack [-1] == (None, None, None):
            return (None, None, None)
        return self.versionStack. pop ()

    def computeScope (self):
        self.scope = "::".join (self.namespaceStack + self.classStack)
        if self.scope == None:
            self.scope == ''
        
    def setDoc (self, text):
        self.doc = text
        
    def getDoc (self):
        text = self.doc
        self.doc = ''
        return text
