#     Copyright 2006 Jim Bublitz <jbublitz@nwinternet.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

usageMsg = """
'report' looks at sip files and produces output for a number
of conditions (each can be enabled/disabled):

  python report.py [-a][-R]   version   path
  python report.py [-m][-n][-s][-y][-R]   version   path
  python report.py [-h]

  where:
    version - the (usually new) version to report on
    (eg KDE_3_80_1)

    path - the path to the directory containing the
    sip files to be reviewed [default]

    or, with -R, the top level sip directory whose
    subdirectories will be scanned
    
    -m   Any //mc or //mt
    -n   New code (version >= version specified)
    -s   Scalar type args used as pointers or references (*. &)
    -y   Versioned out code
  
    -a   All of the above [default]

    -h   This message

"""

import sys, os, os.path
import getopt

directories = []

opt_all  = False
opt_some = False
opt_code = False
opt_new  = False
opt_vers = False
opt_io   = False
opt_one  = True

version  = ""
under    = "--------------------------------------------------------------------------------------------------------------"

def oneDirectory (basename):
    modulePath = os.path.join (path, basename)
    if not os.path.isdir (modulePath):
        print "%s is not a directory" % modulePath
        sys.exit (-1)

    print
    print "report for:      %s" % modulePath
    print "==========\n\n"
                    
    files = os.listdir (modulePath)
    files.sort ()
    for file in files:
        buf = []
        if os.path.splitext (file) [1] != ".sip":
            continue

        filepath = os.path.join (modulePath, file)

        m = open (filepath, "r")
        for line in m:
            if (opt_all or opt_code) and line.startswith ("//m"):
                buf.append (line)

            if (opt_all or opt_io) and line.startswith ("//io"):
                buf.append (line)

            if (opt_all or opt_vers) and line.startswith ("%If"):
                if isClosedVersion (line):
                    buf.append ("\n\n")
                    buf.append (line)
                    printIfBlock (m, buf)
                    buf.append ("\n")

            if (opt_all or opt_new) and line.startswith ("%If"):
                if isNewVersion (line):
                    buf.append ("\n\n")
                    buf.append (line)
                    printIfBlock (m, buf)
                    buf.append ("\n")
        
        m.close ()
        if buf:
            dumpBuffer (filepath, buf)                    

def dumpBuffer (file, buf):        
    print file
    print under [:len (file)]
    print

    for line in buf:
      print line,

    print
    print      
        
def allDirectories ():
    if not os.path.isdir (path):
        print "%s is not a directory" % path
        sys.exit (-1)

    files = os.listdir (path)
    files.sort ()
    for file in files:
        if not os.path.isdir (os.path.join (path, file)):
            continue

        oneDirectory (file)

def isClosedVersion (line):
    if not "-" in line:
        return False
    
    lp = line.find ("(")
    rp = line.find (")")
      
    if not lp > 0 or not rp > 0 or lp > rp:
        print "**** syntax error *****"
        print line,
        return False

    condition = line [lp + 1:rp]
    versions  = condition.split ("-")
    vlow      = versions [0].strip ()
    vhigh     = versions [1].strip ()

    if not vhigh:
        return False

    return vhigh <= version

def isNewVersion (line):
    if not "-" in line:
        return False
    
    lp = line.find ("(")
    rp = line.find (")")
      
    if not lp > 0 or not rp > 0 or lp > rp:
        print "**** syntax error *****"
        print line,
        return False

    condition = line [lp + 1:rp]
    versions  = condition.split ("-")
    vlow      = versions [0].strip ()
    vhigh     = versions [1].strip ()

    if not vlow:
        return False

    return vlow >= version

def printIfBlock (m, buf):
    endCount = 1
    for line in m:
        buf.append (line)

        if line.strip () == "%End":
            endCount -= 1
        elif line.startswith ("%"):
            endCount += 1
                        
        if not endCount:
            return                        
            
def usage ():
    print usageMsg
    sys.exit (-1)

def getOptions (argv):
    try:
        optlist, args = getopt.getopt(argv[1:], "ahmnRsy")
    except getopt.GetoptError:
        usage()


    global opt_all, opt_some, opt_code, opt_new, opt_vers, opt_io, opt_one
    
    for opt, arg in optlist:
        if opt == "-h":
            usage()

        elif opt == "-a":
            if opt_some:
                usage ()
                
            opt_all = True

        elif opt == "-m":
            if opt_all:
                usage ()

            opt_some = True
            opt_code = True                

        elif opt == "-n":
            if opt_all:
                usage ()

            opt_some = True
            opt_new  = True
        
        elif opt == "-R":
            opt_one  = False

        elif opt == "-s":
            if opt_all:
                usage ()

            opt_some = True
            opt_io   = True

        elif opt == "-y":
            if opt_all:
                usage ()

            opt_some = True
            opt_vers = True

    global version

    if len (args) != 2:
        usage ()

    opt_all = not opt_some
    version  = args [0]
    fullpath = args [1]

    return fullpath


if __name__ == "__main__":
    fullpath = getOptions (sys.argv)

    global path
    
    if opt_one:
        path, basename = os.path.split (fullpath)
        oneDirectory (basename)
    else:
        path = fullpath
        allDirectories ()        
        