#     Copyright 2007-8 Jim Bublitz <jbublitz@nwinternet.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

deletedClasses = []

def importFilter (objectList, versionRange):
    # handles objects imported
    resultList = [obj for obj in objectList if _importfilter (obj, versionRange)]
    return resultList
    
def _importfilter (obj, versionRange):
    result = True
    result = not (not obj.version.inRange (versionRange)\
                  or (obj.objectType in ['sipBlock']\
                  or obj.ignore))
                  
    obj.blocks = []

    return result
    
def includeFilter (objectList, modData):
    # handles h file includes
    resultList = [obj for obj in objectList if _includefilter (obj, modData)]
    return resultList
    
def _includefilter (obj, modData):
    global deletedClasses
    result = True
    
    if obj.name.startswith ('operator') and (obj.name in ['operator =', 'operator ++', 'operator --', 'operator QVariant'] or len (obj.arguments) > 1):
        return False 
        
    if obj.name.startswith ('operator QList'):
        return False
    
    if obj.objectType == 'function':
        # any clause true rejects the object/all clauses false accepts
        result = not ((obj.access == 'private' and obj.returns [0].argumentType not in ['dtor', 'ctor'])\
                      or (obj.returns [0].argumentType == 'dtor' and obj.access not in ['private', 'protected'])\
                      or obj.templateParams
                      or deletedClasses)
                      
        if result:
            # remove 'void' arguments
            if len (obj.arguments) == 1 and obj.arguments [0].argumentType == 'void':
                obj.arguments = []
                
            
            # transfer argument flags up to owning object
            for arg in obj.arguments:
                obj.attributes.mcNeeded = obj.attributes.mcNeeded or arg.attributes.mcNeeded
                obj.attributes.mtNeeded = obj.attributes.mtNeeded or arg.attributes.mtNeeded
                obj.attributes.ioNeeded = obj.attributes.ioNeeded or arg.attributes.ioNeeded
                
                if arg.defaultValue == 'true':
                    arg.defaultValue = '1'
                elif arg.defaultValue == 'false':
                    arg.defaultValue = '0'
                    
                if arg.argumentType == 'short int':
                    arg.argumentType = 'short'
                elif arg.argumentType == 'unsigned short int':
                    arg.argumentType = 'unsigned short'
                elif arg.argumentType == 'long unsigned int':
                    arg.argumentType == 'undigned long'
            
            for arg in obj.returns:
                if arg.argumentType == 'short int':
                    arg.argumentType = 'short'
                elif arg.argumentType == 'unsigned short int':
                    arg.argumentType = 'unsigned short'
                elif arg.argumentType == 'long unsigned int':
                    arg.argumentType == 'undigned long'

            if obj.pyName:
                obj.annotation.append ('PyName=%s' % obj.pyName)
                                
            # insert sip macros for slots from h file code
            # arg names, scope are defined in prj file
            found = False
            if len (obj.arguments) > 1:
                for tpl in modData.sipslot:
                    if obj.scope in tpl [2]:
                        for i in range (len (obj.arguments) - 1):
                            arg1 = obj.arguments [i]
                            arg2 = obj.arguments [i + 1]
                            if arg1.argumentType == 'QObject*' and arg2.argumentType == 'char*'\
                                and arg1.argumentName == tpl [0] and arg2.argumentName == tpl [1]:
                                arg1.argumentType = 'SIP_RXOBJ_CON'
                                arg2.argumentType = 'SIP_SLOT_CON ()'
                                
                                # clean up
                                arg1.defaultValue = arg2.defaultValue = ''                                
                                arg1.attributes.cv = arg2.attributes.cv = ''
                                arg1.argumentName = arg2.argumentName = None
                                found = True
                                break
                    if found:
                        break
                        
            # annotate for object ownership
            # arg types, names are defined in prj file
            found = False
            if obj.arguments:
                for am in modData.amends:
                    scope, functionType, name, annotation = am
                    if scope == '*' or scope == obj.scope:
                        if (functionType == 'ctor' and obj.returns [0].argumentType == 'ctor')\
                            or (functionType == 'all'):
                            for arg in obj.arguments:
                                if arg.argumentName == name and arg.argumentType in modData.amendTypes:
                                    if arg.annotation:
                                        arg.annotation.append (annotation)
                                    else:
                                        arg.annotation = [annotation]
                                    found = True
                                    break
                    if found:
                        break

    elif obj.objectType == 'class':
        classAccess = obj.access in  [None, 'public']
        result = not (obj.opaque or not classAccess or deletedClasses)
        if obj.pyName:
            obj.annotation.append ('PyName=%s' % obj.pyName)

        # delete any base classes not supported in this version (or template base classes)
        obj.bases = [base for base in obj.bases if base not in modData.nobase]
        for i in range (len (obj.bases)):
            pos = obj.bases [i].find ('<')
            if pos > 0:
                base = obj.bases [i][:pos]
            else:
                base = obj.bases [i]
            
            # bases where a different base is substituted (eg - replacing a template base)
            if base in modData.subbase:
                obj.bases [i] = modData.subbase [base]

        # delete any forward references - put them back (manually) in the
        # sip file if needed
        if not classAccess and not obj.opaque:
            deletedClasses.append (obj.name)
            
    elif obj.objectType == 'endclass':        
        result = obj.name not in deletedClasses and obj.access in [None, 'public']
        if not result and obj.name in deletedClasses:
            deletedClasses.remove (obj.name)
            
    elif obj.objectType == 'variable':
        result = not (obj.access != 'public' or deletedClasses)
        if obj.pyName:
            obj.annotation.append ('PyName=%s' % obj.pyName)

    else:
        result = not (obj.access == 'private' or deletedClasses)
        if obj.pyName:
            obj.annotation.append ('PyName=%s' % obj.pyName)
        
    return result
    
