#     Copyright 2006 Jim Bublitz <jbublitz@nwinternet.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import sys, os, os.path, shutil, getopt, glob

spaces = "                                                                                 "

dirs4     = ["extra", "doc", "pykdedocs", "examples", "tutorials", "tools"]

topFiles4 = ["AUTHORS", "BUGS", "ChangeLog", "configure.template", "COPYING", "COPYING.LESSER",\
            "importTest.py", "INSTALL", "NEWS", "pykdeconfig.py.in", "README", "THANKS", "__init__.py", "installdocs.py"]

extras  = {
           "kdecore":  ["ksycocafactory.h"],\
           "kdeui":    ["kicontheme.h"]
          }

subdirs = ["kdecore", "kdeui",  "kio"]

def buildFileSystem (prjfile, prjData):
    Clone (prjfile, prjData)

class Clone:
    def __init__ (self, prjfile, prjData):
        self.prjfile = prjfile
        if len (prjData.prj_version) == 9:
            pos = 5
        else:
            pos = 6
        self.version = "kde" + prjData.prj_version [-pos:].replace ("_", "")
        self.src     = prjData.prj_prevpath [0][:-3]
        self.dest    = prjData.prj_destination
        self.kdesrc  = prjData.prj_source
        self.package = prjData.prj_package
        self.isKDE4   = prjData.prj_isKDE4

        self.modules  = []
        self.imports  = {}
        self.includes = {}
        self.libs     = {}
        self.bldData  = {}
        
        print "creating %s" % self.version.upper ()

        if not os.path.exists (self.src):
            print "PyKDE source path %s does not exist" % self.src
            sys.exit (-1)

        if not os.path.exists (self.kdesrc):
            print "KDE source path %s does not exist" % self.kdesrc
            sys.exit (-1)
        
        if os.path.exists (self.dest):
            print "removing old %s" % self.dest
            shutil.rmtree (self.dest)

        print "creating %s" % self.dest
        os.mkdir (self.dest)
        """
        dirs = dirs4
            
        for d in dirs:
            print "copying %s to %s" % (os.path.join (self.src, d), os.path.join (self.dest, d))
            shutil.copytree (os.path.join (self.src, d), os.path.join (self.dest, d))
            if os.path.exists (os.path.join (self.dest, d, ".svn")):
                shutil.rmtree (os.path.join (self.dest, d, ".svn"))

        print "copying files"
        global topFiles
        prjFiles = glob.glob (os.path.join (self.src, "pykde*.prj"))
        
        topFiles = topFiles4 + [os.path.basename (f) for f in prjFiles]
        
        for f in topFiles:
            print "     %s -->> %s" % (os.path.join (self.src, f), os.path.join (self.dest, f))
            shutil.copy (os.path.join (self.src, f), os.path.join (self.dest, f))            

        thisExtra = os.path.join (self.dest, "extra", self.version)
        if not os.path.exists (thisExtra):
            print "creating %s" % thisExtra
            os.mkdir (thisExtra)

        for subdir in subdirs:
            if not os.path.exists (os.path.join (thisExtra, subdir)):
                os.mkdir (os.path.join (thisExtra, subdir))

        print "copying extra files"

 #       shutil.copy (os.path.join (self.src, "extra/typedefs.h"), os.path.join (thisExtra, "kdecore/typedefs.h"))
        for d in extras:
            base  = self.kdesrc
            paths = [os.path.join (base, d)]
            subs  = os.listdir (paths [0])
            for sub in subs:
                test = os.path.join (base, d, sub)
                if os.path.isdir (test):
                    paths.append (test)

            for i in range (len (extras [d])):
                fn = extras [d][i]
                flag = fn == "kicontheme.h"                    
                for path in paths:
                    if "/" in fn:
                        s = os.path.join (path, fn.split ("/") [1])
                    else:
                        s = os.path.join (path, fn)
                                                            
                    if not os.path.exists (s):
                        continue
                    
                    dst = os.path.join (thisExtra, fn)
                                                        
                    shutil.copy (s, dst)
                    break
        
        print "editing files"
        m = open (os.path.join (thisExtra, "kicontheme.h"), "r")
        n = open (os.path.join (thisExtra, "kicontheme.h.tmp"), "w")
        for line in m:
            if "KIconThemeDir" in line:
                n.write ("//" + line)
            else:
                n.write (line)

        m.close ()
        n.close ()
        os.unlink (os.path.join (thisExtra, "kicontheme.h"))
        os.rename (os.path.join (thisExtra, "kicontheme.h.tmp"), os.path.join (thisExtra, "kicontheme.h"))
"""
        self.readProjectFile (prjfile)
        #self.writeConfigFile ()

    def getArg (self, line):
        if not "=" in line:
            print "malformed project file"
            sys.exit (-1)

        tag, args = line.split ("=")
        
        return args.strip ()
    
    def getArgList (self, line):
        if not "=" in line:
            print "malformed project file"
            sys.exit (-1)

        tag, args = line.split ("=")
        args = args.split ()
        arglist = []
        for arg in args:
            arglist.append (arg.strip ())
        
        return arglist 

    def readProjectFile (self, prjfile):
        m = open (prjfile, "r")

        self.modules  = []
        self.includes = {}
        self.libs     = {}
        

        for line in m:
            line = line.strip ()
            if not "build" in line:
                if line.startswith ("module"):
                    currentModule = self.getArg (line) 
                    self.modules.append (currentModule)
                
                elif line.startswith ("include"):
                    incl = self.getArg (line)
                    if incl == "":
                        incl = None                      

                    if not currentModule in self.includes:
                        if incl:
                            self.includes [currentModule] = self.getArgList (line)
                        else:
                            self.includes [currentModule] = incl
                    elif incl:
                        self.includes [currentModule] += incl
                                      
                elif line.startswith ("import ") or line.startswith ("import="):
                    imp = self.getArg (line).split ("/") [0]
                    if not currentModule in self.imports:
                        self.imports [currentModule] = [imp]
                    else:
                        self.imports [currentModule].append (imp)
                
                elif line.startswith ("libs"):
                    if not currentModule in self.libs: 
                        self.libs [currentModule] = self.getArgList (line)
                    else:
                        self.libs [currentModule] += self.getArgList (line)

                continue
            break

        for line in m:
            if line.strip ().startswith ("KDE tags"):
                tags = []
                for line in m:
                    if line.strip ().startswith ("end"):
                        break

                    tags.append (line.strip ())
                    

                self.bldData ["KDE tags"] = tags

            elif "=" in line:
                pair = line.split ("=")
                self.bldData [pair [0].strip ()] = pair [1].strip ()

        m.close ()

    def writeDict (self, file, lval, keys, dict):
        file.write (lval)
        indent = len (lval)
        space  = 0
        j = 0
        for key in keys:
            space = max (space, len (key))
            j += 1
          
        for key in keys:
            file.write ('%s"%s":%s' % (spaces [:(indent - 1)], key, spaces [:(space - len (key) + 1)]))
            if key in dict:
                if not dict [key]:
                    if j == 1:
                        file.write ("None%s}\n" % spaces [:(indent - 1)])
                    else:
                        file.write ('None,\n')
                                                
                    j -= 1
                    continue

                else:
                    file.write ("[")
                    
                i = len (dict [key])
                if i == 0:
                    file.write ("\n")
                else:
                    for item in dict [key]:
                        if i == 1:
                            if j == 1:
                                file.write ('"%s"]' % item)
                                file.write ("\n%s}\n" % spaces [:(indent - 1)])
                            else:
                                file.write ('"%s"],\n' % item)
                        else:
                            file.write ('"%s", ' % item)
                        i -= 1
                j -= 1

        file.write ("\n")
                
        
    def writeConfigFile (self):
#        moduleStr  = "pykde_modules = [%s]" % ", ".join (self.modules)
#
#        print moduleStr
#        self.writeDict ("pykde_includes = {", self.modules, self.includes)
#        self.writeDict ("pykde_libs = {", self.modules, self.libs)
#        self.writeDict ("pykde_imports = {", self.modules, self.imports)
#        self.printDict ("bldData", self.bldData)
        
        m = open (os.path.join (self.dest, "configure.template"), "r")
        n = open (os.path.join (self.dest, "configure.py"), "w")
        flag = False
        for line in m:
            if line.startswith ("$pykde_modules$"):
                n.write ("pykde_modules = [")
                i = len (self.modules)
                for module in self.modules:
                    if i == 1:
                        n.write ('"%s"]\n\n' % module)
                    else:
                        n.write ('"%s", ' % module)
                        i -= 1                        
                continue
            
            elif line.startswith ("$pykde_imports$"):
                self.writeDict (n, "pykde_imports = {\n", self.modules, self.imports)
                continue

            elif line.startswith ("$pykde_includes$"):
                self.writeDict (n, "pykde_includes = {\n", self.modules, self.includes)
                continue
                            
            elif line.startswith ("$pykde_libs$"):
                self.writeDict (n, "pykde_libs = {\n", self.modules, self.libs)
                continue
                
            elif line.startswith ("$pykde_package$"):
                n.write ('pykde_package      = "%s"\n' % self.package)
                continue
            
            if flag:
                if line.strip () == "}":
                    flag = False
                    continue
            elif line.strip ().startswith ("pykde_version "):
                if "PyKDE version" in self.bldData:
                    n.write ("%s= %s\n" % (line.split ("=") [0], self.bldData ["PyKDE version"]))
                else:
                    n.write (line)

            elif line.strip ().startswith ("pykde_version_str"):
                if "PyKDE version string" in self.bldData:
                    n.write ("%s= '%s'\n" % (line.split ("=") [0], self.bldData ["PyKDE version string"]))
                else:
                    n.write (line)

            elif line.strip ().startswith ("kde_max_version"):
                if "KDE max version" in self.bldData:
                    n.write ("%s= %s\n" % (line.split ("=") [0], self.bldData ["KDE max version"]))
                else:
                    n.write (line)

            elif line.strip ().startswith ("kdetags"):
                n.write (line)
                if "KDE tags" in self.bldData:
                  for tag in self.bldData ["KDE tags"]:
                    n.write ("        %s\n" %  tag)
                  n.write ("    }\n")
                  flag = True

            else:
                n.write (line)

        m.close ()
        n.close ()
#        os.unlink (os.path.join (self.dest, "configure.py"))
#        os.rename (os.path.join (self.dest, "configure.py.tmp"), os.path.join (self.dest, "configure.py"))
