#     Copyright 2006 Jim Bublitz <jbublitz@nwinternet.com>
#     Copyright 2006 Jim Bublitz <jbublitz@nwinternet.com>
#     Earlier copyrights 2001-5 Jim Bublitz may also apply
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import re, os.path
from symboldata import Version

class ModuleInfo:

    def __init__ (self):
        self.sipDst = ""
        self.clear ()

    def clear (self):
        #self.dst not cleared
        self.sourcePath  = []
        self.substPath   = []
        self.importPath  = []
        self.imports     = []
        self.modname     = ""
        self.amendTypes  = []
        self.amends      = []
        self.sipslot     = []
        self.disArgs     = []
        self.defines     = []
        self.fileDefines = {}
        self.require     = []
        self.noheader    = []
        self.cast        = []
        self.tracefile   = ""
        self.nobase      = []
        self.isKDE4      = False
        self.nocast      = []
        self.nonamespace = {}

    def reset (self):
        # clear some tables
        pass

    def init (self, prjdata, moddata):
        self.prjdata = prjdata
        self.moddata = moddata
        
        self.sipDst = self.prjdata.prj_destination

        self.importPath.append (prjdata.prj_importpath)
        self.importPath  += moddata.mod_importpath
        
        self.imports = {}
        for tpl in moddata.mod_import:
            modname = os.path.basename (tpl [0])
            if modname.endswith ('mod.sip'):
                modname = modname [:-7]
            self.imports [modname] = Version (tpl [1:])
            
        self.sourcePath  = moddata.mod_source
        self.substPath   = moddata.mod_subst
        self.modname     = moddata.mod_name
        self.version     = prjdata.prj_version
        self.previous    = prjdata.prj_previous
        self.prevpath    = prjdata.prj_prevpath
        self.license     = prjdata.prj_license
        self.amendTypes  = moddata.mod_amendTypes
        self.amends      = moddata.mod_amends
        self.sipslot     = moddata.mod_sipslot
        self.tracefile   = moddata.mod_trace
        self.require     = moddata.mod_require
        self.noheader    = moddata.mod_noheader
        self.cast        = moddata.mod_cast
        self.nocast      = moddata.mod_nocast
        self.nonamespace = moddata.mod_nonamespace
        self.isKDE4      = prjdata.prj_isKDE4
        self.nobase      = moddata.mod_nobase
        self.subbase     = moddata.mod_subbase
        self.defines     = moddata.mod_defines
        self.maindox     = moddata.prjmaindox
        self.values      = {}

        self.initDefines ()

    def initDefines (self):
        baseDefines = [("TWINE",  "")]

        for define in baseDefines:
            if define not in self.defines:
                self.defines.append (define)

        self.defines = self.compileDefines ()

    def compileDefines (self):
        """
       All regexes are pre-compiled
       """
        for define in self.prjdata.prj_defines:
            self.values [define [0]] = define [1]
            
        for define in self.defines:
            self.values [define [0]] = define [1]
            
        # add the original tag as the third tuple element
        # in case we want to find/delete it later (eg - #undef)
        defs = [(re.compile (define [0]), define [1], define [0]) for define in self.prjdata.prj_defines]
        defs += [(re.compile (define [0]), define [1], define [0]) for define in self.defines]
        return defs

class ImportModule:
    """
    Holds version info about an imported module
    """
    def __init__ (self):
        self.importFile   = ""
        self.versionLow   = "-"
        self.versionHigh  = "~"
        self.versPlatform = ""

