#!env python

import cmakelexer
import re

def ExtractInstallFiles(filename=None,input=None):
    lexer = cmakelexer.CMakeLexer()
    if input:
        lexer.input(input)
    elif filename:
        fhandle = open(filename)
        lexer.input(fhandle.read())
        fhandle.close()
    else:
        return []
        
    command_list = FetchCommands(lexer)
    variables = {}
    install_list = []
    for command,args in command_list:
        command = command.lower()
        if command=="set":
            variables[args[0].lower()] = ExpandArgs(variables, args[1:])
        elif command=="install":
            install_args = ExpandArgs(variables, args)
            install_list.extend( [x for x in install_args if x.endswith('.h')] )
            
    #print(repr(variables))
    #print(repr(install_list))
            
    return install_list
    
def ExpandArgs(variables, args):
    rex  = re.compile(r'(\$\{[^\}]+\})')
    fixed_args = []
    for arg in args:
        fixed_parts = []
        #print("arg:"+arg)
        parts = rex.split(arg)
        for part in parts:
            #print("part:"+part)
            if part.startswith("${"):
                name = part[2:-1].lower()
                if name in variables:
                    #print("hit var:"+name)
                    value = variables[name]
                    if len(value)==1:
                        fixed_parts.append(variables[name][0])
                    else:
                        fixed_args.extend(value)
                else:
                    print("Undefined variable: " + name)
            else:
                fixed_parts.append(part)
        fixed_args.append(''.join(fixed_parts))
        
    return fixed_args
    
def FetchCommands(lexer):
    topmode = True
    command_list = []
    command = None
    args = []
    
    tok = lexer.token()
    while 1:
        if not tok:
            if command:
                command_list.append( (command,args) )
            break   # No more input
        if topmode:
            if tok.type=="COMMAND":
                command = tok.value
                topmode = False
            else:
                print("Fail")
                # Fail
                
            tok = lexer.token()
        else:
            # Grab arguments
            if tok.type=="COMMAND":
                if command:
                    command_list.append( (command,args) )
                command = None
                args = []
            
                topmode = True
                continue
            args.append(tok.value)
            tok = lexer.token()
    return command_list
        
if __name__=="__main__":
    #print("Testing")
    #lexer = cmakelexer.CMakeLexer()
    ExtractInstallFiles(input="""
find_package(KDE4 REQUIRED)
include (KDE4Defaults)

include_directories(${CMAKE_CURRENT_SOURCE_DIR} ${KDEBASE_WORKSPACE_SOURCE_DIR}/libs ${CMAKE_CURRENT_SOURCE_DIR}/.. ${KDE4_INCLUDES} ${OPENGL_INCLUDE_DIR})

add_subdirectory(tests)
add_definitions(-DKDE_DEFAULT_DEBUG_AREA=1209)

########### next target ###############

set(plasmagik_SRCS
    packagemetadata.cpp
    packagestructure.cpp
    package.cpp
    )

set(plasma_LIB_SRCS
    ${plasmagik_SRCS}
    abstractrunner.cpp
    animationdriver.cpp
    animator.cpp
    applet.cpp
    appletbrowser.cpp
    appletbrowser/customdragtreeview.cpp
    appletbrowser/kcategorizeditemsview.cpp
    appletbrowser/kcategorizeditemsviewdelegate.cpp
    appletbrowser/kcategorizeditemsviewmodels.cpp
    appletbrowser/openwidgetassistant.cpp
    appletbrowser/plasmaappletitemmodel.cpp
    configxml.cpp
    containment.cpp
    corona.cpp
    datacontainer.cpp
    dataengine.cpp
    dataenginemanager.cpp
    delegate.cpp
    dialog.cpp
    extender.cpp
    extenderitem.cpp
    paintutils.cpp
    panelsvg.cpp
    plasma.cpp
    popupapplet.cpp
    private/applethandle.cpp
    private/datacontainer_p.cpp
    private/desktoptoolbox.cpp
    private/nativetabbar.cpp
    private/packages.cpp
    private/paneltoolbox.cpp
    private/toolbox.cpp
    private/tooltip.cpp
    querymatch.cpp
    runnercontext.cpp
    runnermanager.cpp
    scripting/appletscript.cpp
    scripting/dataenginescript.cpp
    scripting/runnerscript.cpp
    scripting/scriptengine.cpp
    service.cpp
    servicejob.cpp
    svg.cpp
    theme.cpp
    tooltipmanager.cpp
    uiloader.cpp
    version.cpp
    view.cpp
    wallpaper.cpp
    widgets/checkbox.cpp
    widgets/combobox.cpp
    widgets/flash.cpp
    widgets/frame.cpp
    widgets/groupbox.cpp
    widgets/icon.cpp
    widgets/label.cpp
    widgets/lineedit.cpp
    widgets/meter.cpp
    widgets/pushbutton.cpp
    widgets/radiobutton.cpp
    widgets/signalplotter.cpp
    widgets/slider.cpp
    widgets/tabbar.cpp
    widgets/textedit.cpp
    widgets/webcontent.cpp
)

kde4_add_ui_files (
    plasma_LIB_SRCS
    appletbrowser/kcategorizeditemsviewbase.ui
)

if(QT_QTOPENGL_FOUND AND OPENGL_FOUND)
MESSAGE(STATUS "Adding support for OpenGL applets to libplasma")
set(plasma_LIB_SRCS
    ${plasma_LIB_SRCS}
    glapplet.cpp)
endif(QT_QTOPENGL_FOUND AND OPENGL_FOUND)

kde4_add_library(plasma SHARED ${plasma_LIB_SRCS})

target_link_libraries(plasma ${KDE4_KIO_LIBS} ${KDE4_KFILE_LIBS} ${KDE4_KNEWSTUFF2_LIBS}
                             ${QT_QTUITOOLS_LIBRARY} ${QT_QTWEBKIT_LIBRARY}
                             ${KDE4_THREADWEAVER_LIBRARIES} ${KDE4_SOLID_LIBS} ${X11_LIBRARIES})

if(QT_QTOPENGL_FOUND AND OPENGL_FOUND)
    target_link_libraries(plasma ${QT_QTOPENGL_LIBRARY} ${OPENGL_gl_LIBRARY})
endif(QT_QTOPENGL_FOUND AND OPENGL_FOUND)

set_target_properties(plasma PROPERTIES
                             VERSION 3.0.0
                             SOVERSION 3
                             ${KDE4_DISABLE_PROPERTY_}LINK_INTERFACE_LIBRARIES  "${KDE4_KDEUI_LIBS}"
                      )

install(TARGETS plasma ${INSTALL_TARGETS_DEFAULT_ARGS})


########### install files ###############

set(plasmagik_HEADERS
    packagemetadata.h
    packagestructure.h
    package.h
    )

install(FILES ${plasmagik_HEADERS} DESTINATION ${INCLUDE_INSTALL_DIR}/plasma/ COMPONENT Devel)

set(plasma_LIB_INCLUDES
    abstractrunner.h
    animationdriver.h
    animator.h
    applet.h
    appletbrowser.h
    configxml.h
    containment.h
    corona.h
    datacontainer.h
    dataengine.h
    dataenginemanager.h
    delegate.h
    dialog.h
    extender.h
    extenderitem.h
    paintutils.h
    panelsvg.h
    plasma.h
    plasma_export.h
    popupapplet.h
    querymatch.h
    runnercontext.h
    runnermanager.h
    service.h
    servicejob.h
    svg.h
    theme.h
    tooltipmanager.h
    uiloader.h
    tooltipmanager.h
    version.h
    view.h
    wallpaper.h)

if(QT_QTOPENGL_FOUND AND OPENGL_FOUND)
set(plasma_LIB_INCLUDES
    ${plasma_LIB_INCLUDES}
    glapplet.h)
endif(QT_QTOPENGL_FOUND AND OPENGL_FOUND)

install(FILES
        ${plasma_LIB_INCLUDES}
        DESTINATION ${INCLUDE_INSTALL_DIR}/plasma COMPONENT Devel)

install(FILES
    widgets/checkbox.h
    widgets/combobox.h
    widgets/flash.h
    widgets/frame.h
    widgets/groupbox.h
    widgets/icon.h
    widgets/label.h
    widgets/lineedit.h
    widgets/meter.h
    widgets/pushbutton.h
    widgets/radiobutton.h
    widgets/signalplotter.h
    widgets/slider.h
    widgets/tabbar.h
    widgets/textedit.h
    widgets/webcontent.h
    DESTINATION ${INCLUDE_INSTALL_DIR}/plasma/widgets COMPONENT Devel)

install(FILES
    scripting/appletscript.h
    scripting/dataenginescript.h
    scripting/runnerscript.h
    scripting/scriptengine.h
    DESTINATION ${INCLUDE_INSTALL_DIR}/plasma/scripting COMPONENT Devel)


install(FILES
includes/AbstractRunner
includes/AnimationDriver
includes/Animator
includes/Applet
includes/AppletBrowser
includes/AppletScript
includes/CheckBox
includes/ComboBox
includes/ConfigXml
includes/Containment
includes/Corona
includes/DataContainer
includes/DataEngine
includes/DataEngineManager
includes/DataEngineScript
includes/Delegate
includes/Dialog
includes/Extender
includes/ExtenderItem
includes/Flash
includes/GroupBox
includes/Icon
includes/Label
includes/LineEdit
includes/Meter
includes/Package
includes/PackageMetadata
includes/PackageStructure
includes/PaintUtils
includes/PanelSvg
includes/Plasma
includes/PopupApplet
includes/PushButton
includes/QueryMatch
includes/RadioButton
includes/RunnerContext
includes/RunnerManager
includes/RunnerScript
includes/ScriptEngine
includes/Service
includes/ServiceJob
includes/SignalPlotter
includes/Slider
includes/Svg
includes/TabBar
includes/TextEdit
includes/ToolTipManager
includes/Theme
includes/UiLoader
includes/View
includes/Version
includes/Wallpaper
includes/WebContent
DESTINATION ${INCLUDE_INSTALL_DIR}/KDE/Plasma COMPONENT Devel)

if(QT_QTOPENGL_FOUND AND OPENGL_FOUND)
   install(FILES
      includes/GLApplet
      DESTINATION ${INCLUDE_INSTALL_DIR}/KDE/Plasma COMPONENT Devel)
endif(QT_QTOPENGL_FOUND AND OPENGL_FOUND)

install(FILES
   servicetypes/plasma-animator.desktop
   servicetypes/plasma-applet.desktop
   servicetypes/plasma-containment.desktop
   servicetypes/plasma-dataengine.desktop
   servicetypes/plasma-packagestructure.desktop
   servicetypes/plasma-runner.desktop
   servicetypes/plasma-scriptengine.desktop
   servicetypes/plasma-wallpaper.desktop
   DESTINATION ${SERVICETYPES_INSTALL_DIR})

install(FILES scripting/plasmoids.knsrc DESTINATION  ${CONFIG_INSTALL_DIR})   
""")
    # Tokenize
    
    #while 1:
    #    tok = lexer.token()
    #    if not tok: break      # No more input
    #    print tok
    
    #while 1:
    #    tok = cmakelexer.lex.token()
    #    if not tok: break      # No more input
    #    print tok
    
