<?xml version="1.0" encoding="UTF-8"?>

<!--
# Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:tp="http://telepathy.freedesktop.org/wiki/DbusSpec#extensions-v0">

<!-- Base layout of source -->
<xsl:template match="/">
<xsl:text>/* Copyright 2008 Tobias Hunger &lt;tobias.hunger@basyskom.de&gt;
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#include &lt;QtTelepathy/Common/generic_types&gt;
#include &lt;QtTelepathy/Common/HEADER_FILE&gt;

</xsl:text>
<xsl:apply-templates/>
<xsl:text>
</xsl:text>
</xsl:template>

<!-- typedef -->
<!-- nothing to do here -->

<!-- struct -->
<xsl:template match="tp:struct">
  <xsl:call-template name="start_tag">
    <xsl:with-param name="name" select="@name"/>
    <xsl:with-param name="type">struct</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="type_tag">
    <xsl:with-param name="tag">TYPE_PLACEHOLDER</xsl:with-param>
    <xsl:with-param name="tp_type" select="@name"/>
    <xsl:with-param name="base_type">struct</xsl:with-param>
  </xsl:call-template>

  <xsl:text>const QDBusArgument &amp; operator &gt;&gt; (const QDBusArgument &amp; arg,
                                   TYPE_PLACEHOLDER &amp; param)
{
    arg.beginStructure();

</xsl:text>
  <xsl:apply-templates>
    <xsl:with-param name="op">&gt;&gt;</xsl:with-param>
  </xsl:apply-templates>
<xsl:text>
    arg.endStructure();
    return arg;
}

QDBusArgument &amp; operator &lt;&lt; (QDBusArgument &amp; arg,
                             const TYPE_PLACEHOLDER &amp; param)
{
    arg.beginStructure();

</xsl:text>
  <xsl:apply-templates>
    <xsl:with-param name="op">&lt;&lt;</xsl:with-param>
  </xsl:apply-templates>
<xsl:text>
    arg.endStructure();
    return arg;
}
</xsl:text>
  <xsl:call-template name="end_tag">
    <xsl:with-param name="name" select="@name"/>
    <xsl:with-param name="type" select="@type"/>
  </xsl:call-template>
</xsl:template>


<xsl:template match="tp:member">
    <xsl:param name="op"/>
    <xsl:if test="$op">
      <xsl:call-template name="member_tag">
        <xsl:with-param name="name" select="@name"/>
      </xsl:call-template>
      <xsl:text>    arg </xsl:text><xsl:value-of select="$op"/><xsl:text> param.MEMBER_PLACEHOLDER;
</xsl:text>
    </xsl:if>
</xsl:template>

<!-- enums -->
<xsl:template match="tp:enum">
  <xsl:call-template name="start_tag">
    <xsl:with-param name="name" select="@name"/>
    <xsl:with-param name="type">enum</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="type_tag">
    <xsl:with-param name="tag">TYPE_PLACEHOLDER</xsl:with-param>
    <xsl:with-param name="tp_type" select="@name"/>
    <xsl:with-param name="base_type">enum</xsl:with-param>
  </xsl:call-template>

<xsl:text>const QDBusArgument &amp; operator &gt;&gt; (const QDBusArgument &amp; arg,
                                   TYPE_PLACEHOLDER &amp; param)
{
    </xsl:text><xsl:call-template name="eval_type"><xsl:with-param name="type" select="@type"/></xsl:call-template><xsl:text> tmp;
    arg &gt;&gt; tmp;
    param = static_cast&lt; TYPE_PLACEHOLDER &gt;(tmp);
    return arg;
}

QDBusArgument &amp; operator &lt;&lt; (QDBusArgument &amp; arg,
                                   const TYPE_PLACEHOLDER &amp; param)
{
    arg &lt;&lt; static_cast&lt; </xsl:text><xsl:call-template name="eval_type"><xsl:with-param name="type" select="@type"/></xsl:call-template><xsl:text> &gt;(param);
    return arg;
}
</xsl:text>

  <xsl:call-template name="end_tag">
    <xsl:with-param name="name" select="@name"/>
    <xsl:with-param name="type">enum</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- flags -->
<xsl:template match="tp:flags">
  <xsl:call-template name="start_tag">
    <xsl:with-param name="name" select="@name"/>
    <xsl:with-param name="type">enum</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="type_tag">
    <xsl:with-param name="tag">TYPE_PLACEHOLDER</xsl:with-param>
    <xsl:with-param name="tp_type" select="@name"/>
    <xsl:with-param name="base_type">enum</xsl:with-param>
  </xsl:call-template>

<xsl:text>const QDBusArgument &amp; operator &gt;&gt; (const QDBusArgument &amp; arg,
                                   TYPE_PLACEHOLDER &amp; param)
{
    </xsl:text><xsl:call-template name="eval_type"><xsl:with-param name="type" select="@type"/></xsl:call-template><xsl:text> tmp;
    arg &gt;&gt; tmp;
    param = static_cast&lt; TYPE_PLACEHOLDER &gt;(tmp);
    return arg;
}

QDBusArgument &amp; operator &lt;&lt; (QDBusArgument &amp; arg,
                                   const TYPE_PLACEHOLDER &amp; param)
{
    arg &lt;&lt; static_cast&lt; </xsl:text><xsl:call-template name="eval_type"><xsl:with-param name="type" select="@type"/></xsl:call-template><xsl:text> &gt;(param);
    return arg;
}
</xsl:text>

  <xsl:call-template name="end_tag">
    <xsl:with-param name="name" select="@name"/>
    <xsl:with-param name="type">enum</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- mapping -->
<!-- nothing to do here -->

<!-- helper templates -->
<xsl:template name="eval_type">
  <xsl:param name="type"/>

  <xsl:choose>
    <xsl:when test="$type = 'y'">
      <xsl:text>quint8</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'n'">
       <xsl:text>qint16</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'q'">
      <xsl:text>quint16</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'i'">
      <xsl:text>qint32</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'u'">
      <xsl:text>quint32</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'x'">
      <xsl:text>qint64</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 't'">
      <xsl:text>quint64</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'd'">
      <xsl:text>double</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 's'">
      <xsl:text>QString</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'b'">
      <xsl:text>bool</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'v'">
      <xsl:text>QVariant</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'o'">
      <xsl:text>QDBusObjectPath</xsl:text>
    </xsl:when>
    <xsl:when test="$type = 'g'">
      <xsl:text>QDBusSignature</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>UNKNOWN_TYPE_FOUND</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- add tag -->
<xsl:template name="add_tag">
  <xsl:param name="name"/>
  <xsl:param name="value"/>
  <xsl:text>##</xsl:text>
  <xsl:value-of select="$name"/>
  <xsl:text>: </xsl:text>
  <xsl:value-of select="$value"/>
  <xsl:text>#
</xsl:text>
</xsl:template>

<!-- start-tag -->
<xsl:template name="start_tag">
<xsl:param name="name"/>
<xsl:param name="type"/>

<xsl:text>
</xsl:text>
<xsl:call-template name="add_tag">
  <xsl:with-param name="name">START-OF-TYPE</xsl:with-param>
  <xsl:with-param name="value" select="concat($name, '%', $type)"/>
</xsl:call-template>
</xsl:template>

<!-- end-tag -->
<xsl:template name="end_tag">
<xsl:param name="name"/>
<xsl:param name="type"/>

<xsl:call-template name="add_tag">
  <xsl:with-param name="name">END-OF-TYPE</xsl:with-param>
  <xsl:with-param name="value" select="concat($name, '%', $type)"/>
</xsl:call-template>
</xsl:template>


<!-- member tag -->
<xsl:template name="member_tag">
<xsl:param name="name"/>

<xsl:call-template name="add_tag">
  <xsl:with-param name="name">MEMBER_PLACEHOLDER</xsl:with-param>
  <xsl:with-param name="value" select="$name"/>
</xsl:call-template>
</xsl:template>

<!-- Type tags -->
<xsl:template name="type_tag">
<xsl:param name="tag"/>
<xsl:param name="tp_type"/>
<xsl:param name="base_type"/>

  <xsl:choose>
    <xsl:when test="$tp_type">
       <xsl:call-template name="add_tag">
         <xsl:with-param name="name" select="$tag"/>
         <xsl:with-param name="value" select="concat($tp_type, '%', $base_type)"/>
       </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:variable name="ready_type"><xsl:call-template name="eval_type"><xsl:with-param name="type" select="$base_type"/></xsl:call-template></xsl:variable>
      <xsl:call-template name="add_tag">
        <xsl:with-param name="name"><xsl:value-of select="$tag"/></xsl:with-param>
        <xsl:with-param name="value" select="concat($ready_type, '%', $base_type)"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Skip text -->
<xsl:template match="text()"/>

<!-- output definition -->
<xsl:output method="text"/>

</xsl:stylesheet>
