<?xml version="1.0" encoding="UTF-8"?>

<!--
# This XSLT code is based on code found in Telepathy itself. There
# is no license given there, so none is given here either.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:tp="http://telepathy.freedesktop.org/wiki/DbusSpec#extensions-v0">

<xsl:template match="/">

<xsl:comment>
    Copyright 2008 Tobias Hunger &lt;tobias.hunger@basyskom.de&gt;

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    This file was generated by the
        generate_qdbusxml_and_headers_from_tpspec.sh
    script in telepathy-Qt.

    !!! DO NOT EDIT !!!
  </xsl:comment>

<xsl:apply-templates/>
</xsl:template>

<xsl:template match="*">
    <xsl:copy>
        <xsl:for-each select="@*">
            <xsl:choose>
                <xsl:when test="name() = 'tp:type'">
                    <xsl:copy/>
                </xsl:when>
                <xsl:when test="not(starts-with(name(), 'tp:'))">
                    <xsl:copy/>
                </xsl:when>
            </xsl:choose>
        </xsl:for-each>
        <xsl:apply-templates/>
    </xsl:copy>
</xsl:template>

<xsl:template match="tp:*"/>
<xsl:template match="property"/>
<xsl:template match="text()"/>

<xsl:output method="xml" indent="yes" encoding="UTF-8"
    omit-xml-declaration="no"
    doctype-system="http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd"
    doctype-public="-//freedesktop//DTD D-BUS Object Introspection 1.0//EN"/>

</xsl:stylesheet>
