# Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package tp;

$qdbusxml_template = "helpers/tpspec_to_qdbusxml.xslt";
$header_template = "helpers/tpspec_to_typeheaders.xslt";
$sources_template = "helpers/tpspec_to_typesources.xslt";

$keep_tmp_files = 1;
$use_insecure_files = 1;

%known_types = (
                "a{sv}" => "QVariantMap",
                "a{uu}" => "org::freedesktop::Telepathy::HandleHandleMap",
                "a{us}" => "org::freedesktop::Telepathy::HandleStringMap",
                "au"    => "QList< quint32 >",
                "a(u)"  => "QList< quint32 >",
                "as"    => "QStringList",
                "a(s)"  => "QStringList",
                "u"     => "quint32",
                "s"     => "QString",
                "v"     => "QDBusVariant"
                );

# Reserved C++ keywords:
# Telepathy does not accept a limitation on how to name things, so make sure
# they are not using a reserved keyword.
@keywords = (
                "asm",
                "bool", "break",
                "case", "catch", "char", "class", "const", "const_cast", "continue",
                "default", "delete", "do", "double", "dynamic_cast",
                "else", "enum", "explicit", "export", "extern",
                "false", "float", "for", "friend",
                "goto",
                "if", "inline", "int",
                "long",
                "mutable",
                "namespace", "new",
                "operator",
                "private", "public", "protected",
                "register", "reinterpret_cast", "return",
                "short", "signed", "sizeof", "static", "static_cast", "struct", "switch",
                "template", "this", "throw", "true", "try", "typedef",
                    "typeid", "typename",
                "union", "unsigned", "using",
                "virtual", "void", "volatile",
                "wchar_t", "while"
                );

# ------------------- Do not edit below this line! -------------------

sub filename
{
    my $basename = shift;
    my $filename;
    if ($tp::use_insecure_files) { $filename = "/tmp/$basename"; }
    else { $filename = `tempfile`; }
    chomp $filename;
    return $filename;
}

@EXPORT = qw( $qdbusxml_template $header_template $sources_template
              %known_types @keywords filename );

1;
