#!/usr/bin/perl -w

# Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This file takes a telepathy spec file and converts it to XML suitable for
# qdbusxml2cpp.
#
# This script must be run from the scripts/helpers directory of the
# Telepathy-Qt checkout!
#
# usage: cat source | $0 Export_Macro > target_dir

use strict;

my $macro = shift;
die "No export macro given!" unless $macro;

my @reserved_namespaces = ( "Channel", "Connection" );

my $new_typename = "";
my $namespace_level = 0;

while (<>)
{
    my $line = $_;
    chomp $line;

    if ($line =~ /^class (.*)\s*:\s*(.*)$/)
    {
        print "class $macro $1 : $2\n";
        next;
    }

    if ($namespace_level == 0)
    {
        foreach my $i ( @reserved_namespaces )
        {
            if ($line =~ /^\s*namespace\s+$i\s+{\s*$/)
            {
                $new_typename = $i;
                $namespace_level = 1;
                last;
            }
        }
        next if $namespace_level != 0;
    }
    else
    {
        if ($line =~ /^\s*namespace\s+([a-zA-Z0-9_]*)\s+{\s*$/)
        {
            $new_typename .= "$1";
            $namespace_level += 1;
            next;
        }
        if ($line =~ /^(\s*)typedef\s+(::[A-Za-z0-9]*)\s+([A-Za-z0-9]+);\s*$/)
        {
            print "$1typedef $2 ".$new_typename."$3;\n";
            next;
        }
        if ($line =~ /}/)
        {
            $namespace_level -= 1;
            next;
        }
    }

    print "$line\n";
}

exit 0
