#!/bin/sh

# Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script generates XML files that can be used as input to
# qdbusxml2cpp from the XML files found in the telepathy spec.
#
# This script must be run from the scripts dir of the Telepathy-Qt
# checkout!
#
# Usage: $0 Telepathy_spec_dir

# !!! IT WILL OVERWRITE EXISTING SOURCES !!!

check_path()
{
    DIR="$1"
    test "x$DIR" = "x" && exit 1
    test -d "$DIR" || exit 2
    ABS_DIR=`cd "$DIR" ; pwd` # make path absolute
}

check_path "$1"
XML_SRC_DIR="$ABS_DIR"
check_path "../xml"
DBUS_DIR="$ABS_DIR"

for i in `( cd "$XML_SRC_DIR" && ls *.xml )` ; do
    BASENAME=`echo "$i" | sed -e "s/\.xml$//"`;

    ./helpers/tpspec_to_qdbusxml.pl "$BASENAME" "$XML_SRC_DIR" "$DBUS_DIR" || \
         exit 15
    DBUS_FILE="$DBUS_DIR/$BASENAME.xml"
    test -e "${DBUS_FILE}" && xmllint "${DBUS_FILE}"
done

