#!/bin/sh

# Copyright 2006 Will Stephenson <wstephenson@kde.org>
#           2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script generates all the files in Telepathy-Qt!
#
# Call it from the scripts telepathy-qt library!
#
# !!! IT WILL OVERWRITE EXISTING SOURCES !!!

hdr_dir="../include/QtTelepathy/Common"
src_dir="../src/Common"

type_hdr="$hdr_dir/types.h"
qt4_type_hdr="$hdr_dir/Types"

cat > "$type_hdr" << EOF
/* Copyright 2008 Tobias Hunger &lt;tobias.hunger@basyskom.de&gt;
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_COMMON_TYPES_H
#define QTTELEPATHY_COMMON_TYPES_H

#include <QtTelepathy/Common/Common_Export>

EOF

# now the type includes:
for i in `ls ../include/QtTelepathy/Common/*_Types`;
do
	filename=`basename $i`
	echo "#include <QtTelepathy/Common/$filename>" >> "$type_hdr"
done

cat >> "$type_hdr" << EOF

namespace org {
namespace freedesktop {
namespace Telepathy {

/**
 * @brief A helper function to register our types with QtDBus.
 *
 * Call this function before accessing or offering services using Telepathy.
 */
void QTTELEPATHY_COMMON_EXPORT registerTypes();

} // namespace Telepathy
} // namespace freedesktop
} // namespace org

#endif // header guard

EOF

# create Qt4 style header:
echo "#include \"types.h\"" > "$qt4_type_hdr"

# generate source:
src_file="$src_dir/types.cpp"

cat > "$src_file" << EOF
/* Copyright 2008 Tobias Hunger &lt;tobias.hunger@basyskom.de&gt;
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#include <QtTelepathy/Common/Types>

#include <QtDBus/QDBusMetaType>

namespace org {
namespace freedesktop {
namespace Telepathy {

void registerTypes()
{
    static bool registered = false;
    if (!registered)
    {
EOF

# add types:
grep Q_DECLARE_METATYPE ../include/QtTelepathy/Common/* | \
    sed -e 's/^.*Q_DECLARE_METATYPE[(]\(.*\)[)]$/        qDBusRegisterMetaType< \1 >();/' >> "$src_file"

cat >> "$src_file" << EOF
        registered = true;
    }
}

} // namespace
} // namespace
} // namespace

EOF
