#!/bin/sh

# Copyright 2006 Will Stephenson <wstephenson@kde.org>
#           2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script generates all the files in Telepathy-Qt!
#
# Call it from the scripts telepathy-qt library!
#
# !!! IT WILL OVERWRITE EXISTING SOURCES !!!
#
# Usage: $0 [path-to-telepathy]

SPEC_DIR="$1"

test "x$SPEC_DIR" = "x" && SPEC_DIR="../spec"

./generate_qdbusxml_from_tpspec.sh "$SPEC_DIR" || exit 14
./generate_code_from_tpspec.sh "$SPEC_DIR" || exit 15
./generate_helper_source_from_typeheaders.sh || exit 16

./generate_client_sources_from_qdbusxml.sh || exit 17
./generate_core_sources_from_qdbusxml.sh || exit 18
./generate_helper_source_from_typeheaders.sh || exit 19

./generate_cmakelists_from_sources.sh Client || exit 20
./generate_cmakelists_from_sources.sh Core || exit 21
./generate_cmakelists_from_sources.sh Common || exit 22

