#!/bin/bash

# Copyright 2006 Will Stephenson <wstephenson@kde.org>
#           2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script generates all the source files for the QtTelepathy client library
# using the IDL in xml/

# Script to generate CMakeLists.txt files for client library
# Call it from the scripts directory of your telepathy-qt checkout!

# !!! IT WILL OVERWRITE EXISTING SOURCES !!!

COMP="$1"

target="QtTelepathy$COMP"
cpp_dir="../src/$COMP"
test -d "$cpp_dir" || exit 100
cpp_cmakelist="$cpp_dir/CMakeLists.txt"
hdr_dir="../include/QtTelepathy/$COMP"
test -d "$hdr_dir" || exit 101
hdr_cmakelist="$hdr_dir/CMakeLists.txt"

###################################################
# CMakeList.txt for the sources
# Add the header
cat > $cpp_cmakelist << EOF

SET(QT_DONT_USE_QTGUI ON)
SET(QT_USE_QTDBUS ON)
INCLUDE(\${QT_USE_FILE})

SET(INC_DIR \${CMAKE_SOURCE_DIR}/include)
SET(common_DIR \${CMAKE_SOURCE_DIR}/src/Common)
INCLUDE_DIRECTORIES(\${INC_DIR} \${QT_QTCORE_INCLUDE_DIR} \${QT_QTDBUS_INCLUDE_DIR})

# ######### $target library #########

set(common_SRCS
EOF

# now the common sources
for i in `ls ../src/Common/*.cpp`;
do
	filename=`basename $i`
	echo "    \${common_DIR}/$filename" >> $cpp_cmakelist
done

cat >> $cpp_cmakelist << EOF
)

SET(library_SRCS
    \${common_SRCS}
EOF

# Now add the sources
for i in `ls ../src/$COMP/*.cpp`;
do
	filename=`basename $i`
	echo "    $filename" >> $cpp_cmakelist
done
cat >> $cpp_cmakelist << EOF
)

SET(library_MOC_HDRS
EOF

# Now the headers, for moc
for i in `ls ../include/QtTelepathy/$COMP/*.h`
do
	filename=`basename $i`
	echo  "    \${INC_DIR}/QtTelepathy/$COMP/$filename" >> $cpp_cmakelist
done

echo -e "\n)" >> $cpp_cmakelist

echo 'QT4_WRAP_CPP(library_MOC_SRCS ${library_MOC_HDRS})' >> $cpp_cmakelist

echo "ADD_LIBRARY($target SHARED \${library_SRCS} \${library_MOC_SRCS})" >> $cpp_cmakelist
echo "SET_TARGET_PROPERTIES($target PROPERTIES VERSION \${VERSION} SOVERSION \${SO_VERSION})" >> $cpp_cmakelist
echo "TARGET_LINK_LIBRARIES($target \${QT_LIBRARIES})" >> $cpp_cmakelist
echo "INSTALL(TARGETS $target DESTINATION lib)" >> $cpp_cmakelist

#############################################################
# Now create the CMakeLists.txt for the headers

cat > $hdr_cmakelist << EOF
# ######### $target library #########

set(library_HDRS
EOF

# headers
for i in `ls ../include/QtTelepathy/$COMP/*`
do
	filename=`basename $i`
	if [ "$filename" != "CMakeLists.txt" ]
	then
		echo  "    $filename" >> $hdr_cmakelist
	fi
done
echo -e ")\n" >> $hdr_cmakelist

echo "INSTALL(FILES \${library_HDRS} DESTINATION include/QtTelepathy/$COMP)" >> $hdr_cmakelist

