#!/bin/bash

# Copyright 2006 Will Stephenson <wstephenson@kde.org>
#           2008 Tobias Hunger <tobias.hunger@basyskom.de>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script generates all the source files for the QtTelepathyClient library
# using the IDL in xml/
#
# Call it from the scripts telepathy-qt library!
#
# !!! IT WILL OVERWRITE EXISTING SOURCES !!!

lowercase() {
  LOWER=`echo $1 | tr A-Z a-z`
}

for i in `cd ../xml; ls *.xml | sed -e "s/\.xml//"`; do
    classname="${i}"
    xmlfile="../xml/${i}.xml"
    include="-i QtTelepathy/Common/generic_types"
    test -e "../include/QtTelepathy/Common/${i}_Types" && \
        include="${include} -i QtTelepathy/Common/${i}_Types"

    headerinclude="${include} -i QtTelepathy/Client/Client_Export"

    lowercase "${classname}"
    headerfilename="${LOWER}.h"
    sourcefilename="${LOWER}.cpp"

    headerfullname="../include/QtTelepathy/Client/${headerfilename}"
    tmpheaderfullname="${headerfullname}.tmp.h"

    echo
    echo ====================================================================
    echo xmlfile=${xmlfile} classname=${classname} include=${include} lower=${LOWER}

    echo "Generating header file for ${classname}"
    qdbusxml2cpp ${headerinclude} -p \
        "${tmpheaderfullname}:" "${xmlfile}"

    echo "Adding export statements."
    cat "${tmpheaderfullname}" | \
        helpers/sources_postprocessor.pl "QTTELEPATHY_CLIENT_EXPORT" \
        > "${headerfullname}"
    rm "${tmpheaderfullname}"

    echo "Creating Qt4-style header for ${classname}"
    echo "#include \"${headerfilename}\"" \
        > "../include/QtTelepathy/Client/${classname}"

    echo "Generating .cpp file for ${classname}"
    headerinclude="-i QtTelepathy/Client/${classname}"
    qdbusxml2cpp ${headerinclude}  ${include} -p \
        ":../src/Client/${sourcefilename}" "${xmlfile}"
done
