/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_MEDIA_STREAM_HANDLER_TYPES_GENERATED_H
#define QTTELEPATHY_MEDIA_STREAM_HANDLER_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     MediaStreamType
//     StringStringMap
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!





enum MediaStreamBaseProto
{
    MEDIA_STREAM_BASE_PROTO_UDP = 0,
    MEDIA_STREAM_BASE_PROTO_TCP = 1,
    MEDIA_STREAM_BASE_PROTO_MAX
};

struct MediaStreamHandlerCodec
{
    quint32 codecID;
    QString name;
    quint32 mediaType;
    quint32 clockRate;
    quint32 numberOfChannels;
    StringStringMap parameters;
};

enum MediaStreamError
{
    MEDIA_STREAM_ERROR_UNKNOWN = 0,
    MEDIA_STREAM_ERROR_EOS = 1,
    MEDIA_STREAM_ERROR_MAX
};

enum MediaStreamTransportType
{
    MEDIA_STREAM_TRANSPORT_TYPE_LOCAL = 0,
    MEDIA_STREAM_TRANSPORT_TYPE_DERIVED = 1,
    MEDIA_STREAM_TRANSPORT_TYPE_RELAY = 2,
    MEDIA_STREAM_TRANSPORT_TYPE_MAX
};

struct MediaStreamHandlerTransport
{
    quint32 componentNumber;
    QString iPAddress;
    quint32 port;
    MediaStreamBaseProto protocol;
    QString subtype;
    QString profile;
    double preferenceValue;
    MediaStreamTransportType transportType;
    QString username;
    QString password;
};

struct MediaStreamHandlerCandidate
{
    QString name;
    QList< MediaStreamHandlerTransport > transports;
};



} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamHandlerCandidate)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamHandlerCandidate >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamHandlerTransport)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamHandlerTransport >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamHandlerCodec)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamHandlerCodec >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamError)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamError >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamBaseProto)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamBaseProto >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamTransportType)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamTransportType >)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamHandlerCandidate &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamHandlerCandidate &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamHandlerTransport &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamHandlerTransport &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamHandlerCodec &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamHandlerCodec &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamError &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamError &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamBaseProto &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamBaseProto &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamTransportType &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamTransportType &);



#endif // header guard

