/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_CONNECTION_TYPES_GENERATED_H
#define QTTELEPATHY_CONNECTION_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     DBusInterface
//     Handle
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!
enum ConnectionStatus
{
    CONNECTION_STATUS_CONNECTED = 0,
    CONNECTION_STATUS_CONNECTING = 1,
    CONNECTION_STATUS_DISCONNECTED = 2,
    CONNECTION_STATUS_MAX
};


enum HandleType
{
    HANDLE_TYPE_NONE = 0,
    HANDLE_TYPE_CONTACT = 1,
    HANDLE_TYPE_ROOM = 2,
    HANDLE_TYPE_LIST = 3,
    HANDLE_TYPE_GROUP = 4,
    HANDLE_TYPE_MAX
};


enum ConnectionStatusReason
{
    CONNECTION_STATUS_REASON_NONE_SPECIFIED = 0,
    CONNECTION_STATUS_REASON_REQUESTED = 1,
    CONNECTION_STATUS_REASON_NETWORK_ERROR = 2,
    CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED = 3,
    CONNECTION_STATUS_REASON_ENCRYPTION_ERROR = 4,
    CONNECTION_STATUS_REASON_NAME_IN_USE = 5,
    CONNECTION_STATUS_REASON_CERT_NOT_PROVIDED = 6,
    CONNECTION_STATUS_REASON_CERT_UNTRUSTED = 7,
    CONNECTION_STATUS_REASON_CERT_EXPIRED = 8,
    CONNECTION_STATUS_REASON_CERT_NOT_ACTIVATED = 9,
    CONNECTION_STATUS_REASON_CERT_HOSTNAME_MISMATCH = 10,
    CONNECTION_STATUS_REASON_CERT_FINGERPRINT_MISMATCH = 11,
    CONNECTION_STATUS_REASON_CERT_SELF_SIGNED = 12,
    CONNECTION_STATUS_REASON_CERT_OTHER_ERROR = 13,
    CONNECTION_STATUS_REASON_MAX
};


struct ChannelInfo
{
    QDBusObjectPath channel;
    QString channelType;
    HandleType handleType;
    quint32 handle;
};



} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ChannelInfo)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ChannelInfo >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::HandleType)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::HandleType >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ConnectionStatus)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ConnectionStatus >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ConnectionStatusReason)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ConnectionStatusReason >)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ChannelInfo &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ChannelInfo &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::HandleType &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::HandleType &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ConnectionStatus &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ConnectionStatus &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ConnectionStatusReason &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ConnectionStatusReason &);



#endif // header guard

