/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_CONNECTION_INTERFACE_PRESENCE_TYPES_GENERATED_H
#define QTTELEPATHY_CONNECTION_INTERFACE_PRESENCE_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     ContactHandle
//     StringStringMap
//     StringVariantMap
//     UnixTimestamp
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!
enum ConnectionPresenceType
{
    CONNECTION_PRESENCE_TYPE_UNSET = 0,
    CONNECTION_PRESENCE_TYPE_OFFLINE = 1,
    CONNECTION_PRESENCE_TYPE_AVAILABLE = 2,
    CONNECTION_PRESENCE_TYPE_AWAY = 3,
    CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY = 4,
    CONNECTION_PRESENCE_TYPE_HIDDEN = 5,
    CONNECTION_PRESENCE_TYPE_BUSY = 6,
    CONNECTION_PRESENCE_TYPE_MAX
};

struct StatusSpec
{
    ConnectionPresenceType type;
    bool maySetOnSelf;
    bool exclusive;
    StringStringMap parameterTypes;
};

typedef QMap< QString, StatusSpec > StatusSpecMap;

typedef QMap< QString, QVariantMap > MultipleStatusMap;

struct LastActivityAndStatuses
{
    quint32 lastActivity;
    MultipleStatusMap statuses;
};

typedef QMap< quint32, LastActivityAndStatuses > ContactPresences;



} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MultipleStatusMap)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::LastActivityAndStatuses)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ContactPresences)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::StatusSpec)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::StatusSpecMap)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ConnectionPresenceType)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ConnectionPresenceType >)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::LastActivityAndStatuses &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::LastActivityAndStatuses &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::StatusSpec &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::StatusSpec &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ConnectionPresenceType &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ConnectionPresenceType &);



#endif // header guard

