/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_CONNECTION_INTERFACE_CAPABILITIES_TYPES_GENERATED_H
#define QTTELEPATHY_CONNECTION_INTERFACE_CAPABILITIES_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     ContactHandle
//     DBusInterface
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!

enum ConnectionCapabilityFlags
{
    CONNECTION_CAPABILITY_FLAG_CREATE = 1,
    CONNECTION_CAPABILITY_FLAG_INVITE = 2,
    CONNECTION_CAPABILITY_FLAG_MAX = 4
};

struct CapabilityChange
{
    quint32 handle;
    QString channelType;
    ConnectionCapabilityFlags oldGenericFlags;
    ConnectionCapabilityFlags newGenericFlags;
    quint32 oldTypeSpecificFlags;
    quint32 newTypeSpecificFlags;
};

struct ContactCapability
{
    quint32 handle;
    QString channelType;
    ConnectionCapabilityFlags genericFlags;
    quint32 typeSpecificFlags;
};

struct CapabilityPair
{
    QString channelType;
    quint32 typeSpecificFlags;
};





} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ConnectionCapabilityFlags)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ConnectionCapabilityFlags >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::CapabilityPair)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::CapabilityPair >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ContactCapability)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ContactCapability >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::CapabilityChange)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::CapabilityChange >)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ConnectionCapabilityFlags &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ConnectionCapabilityFlags &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::CapabilityPair &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::CapabilityPair &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ContactCapability &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ContactCapability &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::CapabilityChange &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::CapabilityChange &);



#endif // header guard

