/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_CHANNEL_TYPE_TUBES_TYPES_GENERATED_H
#define QTTELEPATHY_CHANNEL_TYPE_TUBES_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     ContactHandle
//     DBusUniqueName
//     StringVariantMap
//     TubeID
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!
enum SocketAccessControl
{
    SOCKET_ACCESS_CONTROL_LOCALHOST = 0,
    SOCKET_ACCESS_CONTROL_PORT = 1,
    SOCKET_ACCESS_CONTROL_NETMASK = 2,
    SOCKET_ACCESS_CONTROL_CREDENTIALS = 3,
    SOCKET_ACCESS_CONTROL_MAX
};

struct SocketNetmaskIPv6
{
    QString address;
    quint8 prefixLength;
};


enum TubeType
{
    TUBE_TYPE_DBUS = 0,
    TUBE_TYPE_STREAM = 1,
    TUBE_TYPE_MAX
};


struct SocketAddressIPv6
{
    QString address;
    quint16 port;
};

struct DBusTubeMember
{
    quint32 handle;
    QString uniqueName;
};


enum SocketAddressType
{
    SOCKET_ADDRESS_TYPE_UNIX = 0,
    SOCKET_ADDRESS_TYPE_ABSTRACT_UNIX = 1,
    SOCKET_ADDRESS_TYPE_IPV4 = 2,
    SOCKET_ADDRESS_TYPE_IPV6 = 3,
    SOCKET_ADDRESS_TYPE_MAX
};

typedef QMap< SocketAddressType, QList< quint32 > > SupportedSocketMap;



enum TubeState
{
    TUBE_STATE_LOCAL_PENDING = 0,
    TUBE_STATE_REMOTE_PENDING = 1,
    TUBE_STATE_OPEN = 2,
    TUBE_STATE_MAX
};

struct TubeInfo
{
    quint32 identifier;
    quint32 initiator;
    TubeType type;
    QString service;
    QVariantMap parameters;
    TubeState state;
};

struct SocketAddressIPv4
{
    QString address;
    quint16 port;
};





struct SocketNetmaskIPv4
{
    QString address;
    quint8 prefixLength;
};



} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::TubeInfo)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::TubeInfo >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::DBusTubeMember)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::DBusTubeMember >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::SocketAddressIPv4)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::SocketAddressIPv4 >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::SocketAddressIPv6)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::SocketAddressIPv6 >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::SocketNetmaskIPv4)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::SocketNetmaskIPv4 >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::SocketNetmaskIPv6)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::SocketNetmaskIPv6 >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::TubeType)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::TubeType >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::TubeState)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::TubeState >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::SocketAddressType)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::SocketAddressType >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::SocketAccessControl)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::SocketAccessControl >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::SupportedSocketMap)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::TubeInfo &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::TubeInfo &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::DBusTubeMember &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::DBusTubeMember &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::SocketAddressIPv4 &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::SocketAddressIPv4 &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::SocketAddressIPv6 &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::SocketAddressIPv6 &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::SocketNetmaskIPv4 &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::SocketNetmaskIPv4 &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::SocketNetmaskIPv6 &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::SocketNetmaskIPv6 &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::TubeType &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::TubeType &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::TubeState &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::TubeState &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::SocketAddressType &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::SocketAddressType &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::SocketAccessControl &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::SocketAccessControl &);



#endif // header guard

