/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_CHANNEL_TYPE_TEXT_TYPES_GENERATED_H
#define QTTELEPATHY_CHANNEL_TYPE_TEXT_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     ContactHandle
//     MessageID
//     UnixTimestamp
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!
enum ChannelTextMessageType
{
    CHANNEL_TEXT_MESSAGE_TYPE_NORMAL = 0,
    CHANNEL_TEXT_MESSAGE_TYPE_ACTION = 1,
    CHANNEL_TEXT_MESSAGE_TYPE_NOTICE = 2,
    CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY = 3,
    CHANNEL_TEXT_MESSAGE_TYPE_DELIVERY_REPORT = 4,
    CHANNEL_TEXT_MESSAGE_TYPE_MAX
};

enum ChannelTextMessageFlags
{
    CHANNEL_TEXT_MESSAGE_FLAG_TRUNCATED = 1,
    CHANNEL_TEXT_MESSAGE_FLAG_NON_TEXT_CONTENT = 2,
    CHANNEL_TEXT_MESSAGE_FLAG_MAX = 4
};



struct PendingTextMessage
{
    quint32 identifier;
    quint32 unixTimestamp;
    quint32 sender;
    ChannelTextMessageType messageType;
    ChannelTextMessageFlags flags;
    QString text;
};



enum ChannelTextSendError
{
    CHANNEL_TEXT_SEND_ERROR_UNKNOWN = 0,
    CHANNEL_TEXT_SEND_ERROR_OFFLINE = 1,
    CHANNEL_TEXT_SEND_ERROR_INVALID_CONTACT = 2,
    CHANNEL_TEXT_SEND_ERROR_PERMISSION_DENIED = 3,
    CHANNEL_TEXT_SEND_ERROR_TOO_LONG = 4,
    CHANNEL_TEXT_SEND_ERROR_NOT_IMPLEMENTED = 5,
    CHANNEL_TEXT_SEND_ERROR_MAX
};


} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PendingTextMessage)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::PendingTextMessage >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ChannelTextSendError)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ChannelTextSendError >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ChannelTextMessageType)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ChannelTextMessageType >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ChannelTextMessageFlags)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ChannelTextMessageFlags >)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::PendingTextMessage &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::PendingTextMessage &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ChannelTextSendError &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ChannelTextSendError &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ChannelTextMessageType &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ChannelTextMessageType &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ChannelTextMessageFlags &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ChannelTextMessageFlags &);



#endif // header guard

