/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_CHANNEL_TYPE_STREAMED_MEDIA_TYPES_GENERATED_H
#define QTTELEPATHY_CHANNEL_TYPE_STREAMED_MEDIA_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     ContactHandle
//     StreamID
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!

enum MediaStreamType
{
    MEDIA_STREAM_TYPE_AUDIO = 0,
    MEDIA_STREAM_TYPE_VIDEO = 1,
    MEDIA_STREAM_TYPE_MAX
};

enum ChannelMediaCapabilities
{
    CHANNEL_MEDIA_CAPABILITY_AUDIO = 1,
    CHANNEL_MEDIA_CAPABILITY_VIDEO = 2,
    CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_STUN = 4,
    CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_GTALK_P2P = 8,
    CHANNEL_MEDIA_CAPABILITY_MAX = 4
};


enum MediaStreamDirection
{
    MEDIA_STREAM_DIRECTION_NONE = 0,
    MEDIA_STREAM_DIRECTION_SEND = 1,
    MEDIA_STREAM_DIRECTION_RECEIVE = 2,
    MEDIA_STREAM_DIRECTION_BIDIRECTIONAL = 3,
    MEDIA_STREAM_DIRECTION_MAX
};


enum MediaStreamPendingSend
{
    MEDIA_STREAM_PENDING_LOCAL_SEND = 1,
    MEDIA_STREAM_PENDING_REMOTE_SEND = 2,
    MEDIA_STREAM_PENDING_MAX = 4
};




enum MediaStreamState
{
    MEDIA_STREAM_STATE_DISCONNECTED = 0,
    MEDIA_STREAM_STATE_CONNECTING = 1,
    MEDIA_STREAM_STATE_CONNECTED = 2,
    MEDIA_STREAM_STATE_MAX
};

struct MediaStreamInfo
{
    quint32 identifier;
    quint32 contact;
    MediaStreamType type;
    MediaStreamState state;
    MediaStreamDirection direction;
    MediaStreamPendingSend pendingSendFlags;
};


} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamType)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamType >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamState)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamState >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamDirection)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamDirection >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamPendingSend)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamPendingSend >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::MediaStreamInfo)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::MediaStreamInfo >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ChannelMediaCapabilities)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ChannelMediaCapabilities >)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamType &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamType &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamState &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamState &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamDirection &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamDirection &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamPendingSend &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamPendingSend &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::MediaStreamInfo &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::MediaStreamInfo &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ChannelMediaCapabilities &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ChannelMediaCapabilities &);



#endif // header guard

