/* Copyright 2008 Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This code is generated from the telepathy specification.
 * DO NOT EDIT!
 */

#ifndef QTTELEPATHY_CHANNEL_INTERFACE_GROUP_TYPES_GENERATED_H
#define QTTELEPATHY_CHANNEL_INTERFACE_GROUP_TYPES_GENERATED_H

#include <QtTelepathy/Common/Common_Export>
#include <QtTelepathy/Common/generic_types>

namespace org {
namespace freedesktop {
namespace Telepathy {

// The following types are not defined inside the current XML file:
//     ContactHandle
// You have to make sure that they are either defined in generic-types
// or are typedefs to simple data types!
enum ChannelGroupChangeReason
{
    CHANNEL_GROUP_CHANGE_REASON_NONE = 0,
    CHANNEL_GROUP_CHANGE_REASON_OFFLINE = 1,
    CHANNEL_GROUP_CHANGE_REASON_KICKED = 2,
    CHANNEL_GROUP_CHANGE_REASON_BUSY = 3,
    CHANNEL_GROUP_CHANGE_REASON_INVITED = 4,
    CHANNEL_GROUP_CHANGE_REASON_BANNED = 5,
    CHANNEL_GROUP_CHANGE_REASON_ERROR = 6,
    CHANNEL_GROUP_CHANGE_REASON_INVALID_CONTACT = 7,
    CHANNEL_GROUP_CHANGE_REASON_NO_ANSWER = 8,
    CHANNEL_GROUP_CHANGE_REASON_RENAMED = 9,
    CHANNEL_GROUP_CHANGE_REASON_PERMISSION_DENIED = 10,
    CHANNEL_GROUP_CHANGE_REASON_SEPARATED = 11,
    CHANNEL_GROUP_CHANGE_REASON_MAX
};

enum ChannelGroupFlags
{
    CHANNEL_GROUP_FLAG_CAN_ADD = 1,
    CHANNEL_GROUP_FLAG_CAN_REMOVE = 2,
    CHANNEL_GROUP_FLAG_CAN_RESCIND = 4,
    CHANNEL_GROUP_FLAG_MESSAGE_ADD = 8,
    CHANNEL_GROUP_FLAG_MESSAGE_REMOVE = 16,
    CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT = 32,
    CHANNEL_GROUP_FLAG_MESSAGE_REJECT = 64,
    CHANNEL_GROUP_FLAG_MESSAGE_RESCIND = 128,
    CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES = 256,
    CHANNEL_GROUP_FLAG_ONLY_ONE_GROUP = 512,
    CHANNEL_GROUP_FLAG_HANDLE_OWNERS_NOT_AVAILABLE = 1024,
    CHANNEL_GROUP_FLAG_PROPERTIES = 2048,
    CHANNEL_GROUP_FLAG_MAX = 4096
};



struct LocalPendingInfo
{
    quint32 toBeAdded;
    quint32 actor;
    ChannelGroupChangeReason reason;
    QString message;
};



} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::LocalPendingInfo)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::LocalPendingInfo >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ChannelGroupFlags)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ChannelGroupFlags >)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::ChannelGroupChangeReason)
Q_DECLARE_METATYPE(QList< org::freedesktop::Telepathy::ChannelGroupChangeReason >)

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::LocalPendingInfo &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::LocalPendingInfo &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ChannelGroupFlags &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ChannelGroupFlags &);

QTTELEPATHY_COMMON_EXPORT const QDBusArgument & operator >> (const QDBusArgument &, org::freedesktop::Telepathy::ChannelGroupChangeReason &);
QTTELEPATHY_COMMON_EXPORT QDBusArgument & operator << (QDBusArgument &, const org::freedesktop::Telepathy::ChannelGroupChangeReason &);



#endif // header guard

