/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2007 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include <QtCore/QDebug>
#include "QtTapioca/Stream"
#include "QtTapioca/Connection"

namespace QtTapioca {

class StreamPrivate {
public:
    StreamPrivate(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm)
        : telepathyStreamedMedia(sm)
    {
    }
    ~StreamPrivate()
    {
    }

    org::freedesktop::Telepathy::ChannelTypeStreamedMedia *telepathyStreamedMedia;
};

}

using namespace QtTapioca;

Stream::Stream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm,
               uint id, uint contact, uint type, uint state,
               uint direction, uint flags, QObject *parent)
    : QObject(parent),
      m_id(id),
      m_type(static_cast<Type>(type)),
      m_contact(contact),
      m_direction(direction),
      m_flags(flags),
      m_state((StreamState)Stream::Connecting),
      d(new StreamPrivate(sm))
{
    Q_ASSERT(d);

    QObject::connect(d->telepathyStreamedMedia, SIGNAL(StreamError(uint, uint, const QString &)),
                     this, SLOT(onStreamError(uint, uint, const QString &)));
    QObject::connect(d->telepathyStreamedMedia, SIGNAL(StreamStateChanged(uint, uint)),
                     this, SLOT(onStreamStateChanged(uint, uint)));
}

Stream::Stream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm,
               uint id, uint contact, uint type, QObject *parent)
    : QObject(parent),
      m_id(id),
      m_type(static_cast<Type>(type)),
      m_contact(contact),
      m_direction(0),
      m_flags(0),
      m_state(static_cast<StreamState>(Stream::Connecting)),
      d(new StreamPrivate(sm))
{
    Q_ASSERT(d);

    QObject::connect(d->telepathyStreamedMedia, SIGNAL(StreamError(uint, uint, const QString &)),
                     this, SLOT(onStreamError(uint, uint, const QString &)));
    QObject::connect(d->telepathyStreamedMedia, SIGNAL(StreamStateChanged(uint, uint)),
                     this, SLOT(onStreamStateChanged(uint, uint)));
}

Stream::~Stream()
{
    delete d;
}

void Stream::pause(bool value)
{
    qDebug() << "Not implemented yet";
}

void Stream::onStreamError(uint id, uint error, const QString &msg)
{
    if (m_id == id)
        emit streamError(this, error, msg);
}

void Stream::onStreamStateChanged(uint id, uint state)
{
    if (m_id == id) {
        m_state = (StreamState) state;
        emit stateChanged(this, (StreamState) state);
    }
}
