/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 * Copyright (C) 2008 by basysKom GmbH
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *  @author Tobias Hunger <decibel@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include <QtTapioca/PropertyObject>

#include <QtDBus/QDBusConnection>

#include <QtTelepathy/Client/Properties_Interface>

// =========================================================================
// Private class:
// =========================================================================

namespace QtTapioca
{

class PropertyObjectPrivate
{
public:
    PropertyObjectPrivate(const QString &serviceName,
                          const QString &objPath, QObject * parent) :
        m_propIface(serviceName, objPath, QDBusConnection::sessionBus(), parent)
    { }

    ~PropertyObjectPrivate()
    { }

    org::freedesktop::Telepathy::Properties m_propIface;
};

} // namespace

// =========================================================================
// PropertyObject:
// =========================================================================

QtTapioca::PropertyObject::PropertyObject(const QString &serviceName,
                                          const QString &objPath,
                                          QObject *parent) :
    DBusProxyObject(serviceName, objPath, parent),
    d(new PropertyObjectPrivate(serviceName, objPath, this))
{
    Q_ASSERT(0 != d);
}

QtTapioca::PropertyObject::~PropertyObject()
{ delete d; }

bool QtTapioca::PropertyObject::hasPropertySupport() const
{ return d->m_propIface.isValid(); }

QStringList QtTapioca::PropertyObject::getPropertyList() const
{
    if (!d->m_propIface.isValid()) return QStringList();

    // FIXME:Implement me!
    return QStringList();
}

bool QtTapioca::PropertyObject::isWriteable(const QString &) const
{
    if (!d->m_propIface.isValid()) return false;

    // FIXME: Implement me!
    return false;
}

bool QtTapioca::PropertyObject::isReadable(const QString &) const
{
    if (!d->m_propIface.isValid()) return false;

    // FIXME: Implement me!
    return false;
}

QVariant QtTapioca::PropertyObject::getProperty(const QString &) const
{
    if (!d->m_propIface.isValid()) return QVariant();

    // FIXME: Implement me!
    return QVariant();
}

bool QtTapioca::PropertyObject::setProperty(const QString &, QVariant &)
{
    if (!d->m_propIface.isValid()) return false;

    // FIXME: Implement me!
    return false;
}
