/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2008 George Goldberg
 *  @author George Goldberg <grundleborg@googlemail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "QtTapioca/PresenceState"

#include <QtDBus/QDBusArgument>

using namespace QtTapioca;

PresenceState::PresenceState(QString name,
                            PresenceState::Type type,
                            bool maySetOnSelf)
  : m_name(name),
    m_type(type),
    m_maySetOnSelf(maySetOnSelf)
{ }

QString PresenceState::name() const
{
    return m_name;
}

QtTapioca::PresenceState::Type PresenceState::type() const
{
    return m_type;
}

bool PresenceState::maySetOnSelf() const
{
    return m_maySetOnSelf;
}

bool PresenceState::operator==(const QtTapioca::PresenceState & other) const
{
    return ((m_name == other.m_name)
            && (m_type == other.m_type)
            && (m_maySetOnSelf == other.m_maySetOnSelf));
}

bool PresenceState::operator!=(const QtTapioca::PresenceState & other) const
{
    return !(*this == other);
}

const QDBusArgument & operator << (QDBusArgument & arg,
                                   const QtTapioca::PresenceState & state)
{
    arg.beginStructure();
    arg << state.name()
        << static_cast<uint>(state.type())
        << state.maySetOnSelf();
    arg.endStructure();
    return arg;
}

const QDBusArgument & operator >> (const QDBusArgument & arg,
                                   QtTapioca::PresenceState & state)
{
    QString name;
    uint type_temp;
    bool maySetOnSelf;

    arg.beginStructure();
    arg >> name
        >> type_temp
        >> maySetOnSelf;
    arg.endStructure();

    QtTapioca::PresenceState::Type type = static_cast<QtTapioca::PresenceState::Type>(type_temp);

    state = QtTapioca::PresenceState(name, type, maySetOnSelf);

    return arg;
}
