/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2007 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include <QDebug>
#include "QtTapioca/AudioStream"
#include "QtTapioca/StreamChannel"

namespace QtTapioca {

class AudioStreamPrivate {
public:
    AudioStreamPrivate(org::freedesktop::Telepathy::StreamEngine *se)
  //      : muteIn(false),
   //       muteOut(false),
 //         volume(0),
  //        telepathyStreamEngine(se)
    {
    }
    ~AudioStreamPrivate()
    {
    }

    bool muteIn;
    bool muteOut;
    uint volume;
    org::freedesktop::Telepathy::StreamEngine *telepathyStreamEngine;
};

}

using namespace QtTapioca;

AudioStream::AudioStream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm,
                         org::freedesktop::Telepathy::StreamEngine *se,
                         uint id, uint contact, uint type, QObject *parent)
 //   : Stream(sm, id, contact, type, parent),
 //     d(new AudioStreamPrivate(se))
{
}

AudioStream::AudioStream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm,
                         org::freedesktop::Telepathy::StreamEngine *se,
                         uint id,
                         uint contact,
                         uint type,
                         uint state,
                         uint direction,
                         uint flags,
                         QObject *parent)
 //   : Stream(sm, id, contact, type, state, direction, flags, parent),
 //     d(new AudioStreamPrivate(se))
{
}

AudioStream::~AudioStream()
{
//    delete d;
}

void AudioStream::setVolume(uint vol)
{
  /*  Q_ASSERT(d->telepathyStreamEngine);

    if (vol == d->volume) {
        qDebug() << "Current volume is equal to the new volume.";
        return;
    }

    StreamChannel *sch = dynamic_cast<StreamChannel *>(parent());
    QDBusReply<void> reply = d->telepathyStreamEngine->SetOutputVolume(QDBusObjectPath(sch->objectPath()), m_id, vol);

    if (!reply.isValid())
        qDebug() << "Unable to set a new volume:" << reply.error().message();
    else
        d->volume = vol;
*/
}

uint AudioStream::volume() const
{
//    return d->volume;
}

void AudioStream::muteIn(bool value)
{
 /*   Q_ASSERT(d->telepathyStreamEngine);

    if (value == d->muteIn) {
        qDebug() << "MuteIn is already" << value;
        return;
    }

    StreamChannel *sch = dynamic_cast<StreamChannel *>(parent());
    QDBusReply<void> reply = d->telepathyStreamEngine->MuteInput(QDBusObjectPath(sch->objectPath()), m_id, value);

    if (!reply.isValid())
        qDebug() << "Unable to set MuteIn to" << value << ":" <<  reply.error().message();
    else
        d->muteIn = value;
*/
}

void AudioStream::muteOut(bool value)
{
/*    Q_ASSERT(d->telepathyStreamEngine);

    if (value == d->muteOut) {
        qDebug() << "MuteOut is already" << value;
        return;
    }

    StreamChannel *sch = dynamic_cast<StreamChannel *>(parent());
    QDBusReply<void> reply = d->telepathyStreamEngine->MuteOutput(QDBusObjectPath(sch->objectPath()), m_id, value);

    if (!reply.isValid())
        qDebug() << "Unable to set MuteOut to" << value << ":" <<  reply.error().message();
    else
        d->muteOut = value;
*/
}
