/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2007 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */
#ifndef QTTAPIOCA_VIDEO_STREAM_H
#define QTTAPIOCA_VIDEO_STREAM_H

#include <QtTapioca/TapiocaExport>

#include <QtCore/QObject>

#include <QtTapioca/Stream>
#include <QtTelepathy/Client/StreamEngine>
#include <QtTelepathy/Client/Channel_Type_Streamed_Media>

namespace QtTapioca {

class StreamChannel;
class VideoStreamPrivate;

class QTTAPIOCA_EXPORT VideoStream: public Stream {
    Q_OBJECT
    Q_DECLARE_PRIVATE(VideoStream)

public:
    ~VideoStream();

    uint windowId() const;
    void setWindowId(uint id);
    void addPreviewWindowId(uint id);
    void removePreviewWindowId(uint id);

private:
    friend class StreamChannel;

    VideoStream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm, org::freedesktop::Telepathy::StreamEngine *se, uint id, uint contact, uint type, QObject *parent);
    VideoStream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm, org::freedesktop::Telepathy::StreamEngine *se, uint id, uint contact, uint type, uint state, uint direction, uint flags, QObject *parent);
    VideoStreamPrivate *d;
};

} // namespace

#endif

