/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */
#ifndef QTTAPIOCA_USER_CONTACT_H
#define QTTAPIOCA_USER_CONTACT_H

#include <QtTapioca/TapiocaExport>

#include <QtCore/QObject>
#include <QtCore/QString>

#include <QtTapioca/ContactBase>
#include <QtTapioca/PresenceState>

#include <QtTelepathy/Client/Connection>
#include <QtTelepathy/Client/Connection_Interface_Avatars>
#include <QtTelepathy/Client/Connection_Interface_Presence>
#include <QtTelepathy/Client/Connection_Interface_Aliasing>
#include <QtTelepathy/Client/Connection_Interface_Capabilities>

namespace QtTapioca {

class UserContactPrivate;
class Avatar;
class Handle;

class QTTAPIOCA_EXPORT UserContact : public ContactBase {
    Q_OBJECT
    Q_DECLARE_PRIVATE(UserContact)

public:
    ~UserContact();

    bool setAvatar(Avatar *avatar);
    bool setPresence(const QtTapioca::PresenceState & state);
    bool setPresenceMessage(const QString &message);
    bool setPresenceParameters(const QVariantMap &params);
    bool setPresenceWithMessage(const QtTapioca::PresenceState & state, const QString & message);
    bool setPresenceWithParameters(const QtTapioca::PresenceState & state, const QVariantMap & params);
    bool setAlias(const QString &alias);
    bool setCapabilities(QList<ContactBase::Capability> caps);

private:
    friend class Connection;
    UserContact(QtTapioca::Connection * connection,
                org::freedesktop::Telepathy::Connection *telepathyConn,
                org::freedesktop::Telepathy::ConnectionInterfaceAvatars  *iAvatar,
                org::freedesktop::Telepathy::ConnectionInterfacePresence *iPresence,
                org::freedesktop::Telepathy::ConnectionInterfaceAliasing *iAliasing,
                org::freedesktop::Telepathy::ConnectionInterfaceCapabilities *iCapabilities,
                Handle *handle, QObject *parent = 0);

    // void setPresenceStatus(const QString &presenceStr, const QString &message);
    UserContactPrivate *d;
};

} // namespace

#endif

