/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 * Copyright (C) 2008 by basysKom GmbH
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *  @author Tobias Hunger <decibel@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_PROPERTYOBJECT_H
#define QTTAPIOCA_PROPERTYOBJECT_H

#include <QtTapioca/TapiocaExport>
#include <QtTapioca/DBusProxyObject>

#include <QtCore/QStringList>
#include <QtCore/QVariant>

namespace QtTapioca {

class PropertyObjectPrivate;

class QTTAPIOCA_EXPORT PropertyObject : public DBusProxyObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(PropertyObject)

public:
    ~PropertyObject();

    bool hasPropertySupport() const;

    QStringList getPropertyList() const;
    bool isWriteable(const QString &) const;
    bool isReadable(const QString &) const;

    QVariant getProperty(const QString &) const;
    bool setProperty(const QString &, QVariant &);

Q_SIGNALS:
    void becameReadable(const QString &);
    void becameWriteable(const QString &);
    void valueChanged(const QString &, QVariant &);

protected:
    PropertyObject(const QString &serviceName, const QString &objPath,
                   QObject *parent = 0);

private:
    PropertyObjectPrivate *d;
};

} // namespace

#endif // header guard
