/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2008 George Goldberg <grundleborg@googlemail.com>
 *  @author George Goldberg <grundleborg@googlemail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */
#ifndef QTTAPIOCA_PRESENCE_STATE_H
#define QTTAPIOCA_PRESENCE_STATE_H

#include <QtTapioca/TapiocaExport>

#include <QtCore/QMetaType>
#include <QtCore/QString>
#include <QtDBus/QDBusArgument>

namespace QtTapioca {

class QTTAPIOCA_EXPORT PresenceState {

public:
    enum Type {
        UnsetType = 0,
        OfflineType = 1,
        AvailableType = 2,
        AwayType = 3,
        ExtendedAwayType = 4,
        HiddenType = 5,
        BusyType = 6
    };

    PresenceState(QString name = QString(),
                  QtTapioca::PresenceState::Type type = QtTapioca::PresenceState::UnsetType,
                  bool maySetOnSelf = true);

    ~PresenceState() { }

    QString name() const;
    QtTapioca::PresenceState::Type type() const;
    bool maySetOnSelf() const;

    bool operator==(const QtTapioca::PresenceState &other) const;
    bool operator!=(const QtTapioca::PresenceState &other) const;

private:
    QString m_name;
    QtTapioca::PresenceState::Type m_type;
    // TODO: Should this be a QFlag instead of a bool, to make it clearer?
    // TODO: Also, could this have a better name?
    bool m_maySetOnSelf;
};

} // namespace

const QDBusArgument & operator >> (const QDBusArgument & arg,
                                   QtTapioca::PresenceState & state);

const QDBusArgument & operator << (QDBusArgument & arg,
                                   const QtTapioca::PresenceState & state);

Q_DECLARE_METATYPE(QtTapioca::PresenceState)

#endif  // header guard

