/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_HANDLE_H
#define QTTAPIOCA_HANDLE_H

#include <QtTapioca/TapiocaExport>

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QPointer>

#include <QtTelepathy/Client/Connection>

namespace QtTapioca {

class HandleFactory;

class QTTAPIOCA_EXPORT Handle : QObject {
    Q_ENUMS(Type)

public:
    enum Type {
        None = 0 /** No type */,
        Contact /** Contact handle */,
        Room /** Room handle */,
        List /** List handle */
    };

    ~Handle();

    QString inspect();
    uint type() const;
    uint id() const;
    bool isValid() const;

    bool operator==(const Handle &handle) const;

private:

    friend class HandleFactory;

    Handle(org::freedesktop::Telepathy::Connection *conn, uint type, const QString &name, QObject *parent);
    Handle(org::freedesktop::Telepathy::Connection *conn, uint type, uint id, QObject *parent);

    uint request(const QString &name);
    void hold();
    void release();

    QPointer<org::freedesktop::Telepathy::Connection> m_conn;
    uint m_type;
    uint m_id;
    bool m_isValid;
};

} // namespace

#endif

