/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CONTACT_BASE_H
#define QTTAPIOCA_CONTACT_BASE_H

#include <QtTapioca/TapiocaExport>

#include <QtCore/QObject>
#include <QtCore/QString>

#include <QtTapioca/ChannelTarget>
#include <QtTapioca/PresenceState>

#include <QtTelepathy/Client/Connection>
#include <QtTelepathy/Client/Connection_Interface_Avatars>
#include <QtTelepathy/Client/Connection_Interface_Presence>
#include <QtTelepathy/Client/Connection_Interface_Aliasing>
#include <QtTelepathy/Client/Connection_Interface_Capabilities>

namespace QtTapioca {

class Avatar;
class Connection;
class ContactBasePrivate;
class Handle;

class QTTAPIOCA_EXPORT ContactBase: public ChannelTarget {
    Q_OBJECT
    Q_DECLARE_PRIVATE(ContactBase)
    Q_ENUMS(Capability)

public:
    enum Capability {
        None  = 0x00,
        Text  = 0x01,
        Audio = 0x02,
        Video = 0x03,
        All   = 0xFF
    };

    ~ContactBase();

    void requestAvatar();
    QString currentAvatarToken();
    QtTapioca::PresenceState presence() const;
    QString presenceMessage() const;
    QString alias() const;
    QList<Capability> capabilities() const;

    bool operator==(const ContactBase &info) const;

Q_SIGNALS:
    void avatarReceived(QtTapioca::ContactBase *contactBase, QtTapioca::Avatar *avatar);
    void avatarUpdated(QtTapioca::ContactBase *contactBase, const QString &newToken);
    void presenceUpdated(QtTapioca::ContactBase *contactBase, const QtTapioca::PresenceState &presence, const QVariantMap &presenceParams);
    void aliasChanged(QtTapioca::ContactBase *contactBase, const QString &alias);
    void capabilitiesChanged(QtTapioca::ContactBase *contactBase, QtTapioca::ContactBase::Capability capabilities);

protected:
    ContactBase(QtTapioca::Connection * connection,
                org::freedesktop::Telepathy::Connection *telepathyConn,
                org::freedesktop::Telepathy::ConnectionInterfaceAvatars  *telepathyIAvatar,
                org::freedesktop::Telepathy::ConnectionInterfacePresence *telepathyIPresence,
                org::freedesktop::Telepathy::ConnectionInterfaceAliasing *telepathyIAliasing,
                org::freedesktop::Telepathy::ConnectionInterfaceCapabilities *telepathyICapabilities,
                Handle *contact_handle,
                QObject *parent = 0);

    void updateCapabilities(const QString &channelType, quint32 typeSpecificFlags);
    void initCapabilities();

    QtTapioca::PresenceState m_presence;
    QVariantMap m_presenceParams;
    QtTapioca::Connection * m_connection;
    org::freedesktop::Telepathy::ConnectionInterfaceAvatars  *telepathyIAvatar;
    org::freedesktop::Telepathy::ConnectionInterfacePresence *telepathyIPresence;
    org::freedesktop::Telepathy::ConnectionInterfaceAliasing *telepathyIAliasing;
    org::freedesktop::Telepathy::ConnectionInterfaceCapabilities *telepathyICapabilities;

private Q_SLOTS:
    void onPresenceUpdated(const org::freedesktop::Telepathy::ContactPresences newPresence);
    void onAvatarUpdated(uint contact, const QString &newAvatarToken);
    void onAliasChanged(QList<org::freedesktop::Telepathy::AliasPair> aliases);
    void onCapabilitiesChanged(QList<org::freedesktop::Telepathy::CapabilityChange> caps);

private:

    ContactBasePrivate *d;
};

} // namespace

#endif

