/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CONTACT_H
#define QTTAPIOCA_CONTACT_H

#include <QtTapioca/TapiocaExport>

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtTapioca/ContactBase>

#include <QtTelepathy/Client/Connection>
#include <QtTelepathy/Client/Connection_Interface_Avatars>
#include <QtTelepathy/Client/Connection_Interface_Presence>
#include <QtTelepathy/Client/Connection_Interface_Aliasing>
#include <QtTelepathy/Client/Connection_Interface_Capabilities>
#include <QtTelepathy/Client/Channel_Interface_Group>

namespace QtTapioca {

class ContactPrivate;

class QTTAPIOCA_EXPORT Contact: public ContactBase {
    Q_OBJECT
    Q_DECLARE_PRIVATE(Contact)
    Q_ENUMS(SubscriptionStatus)
    Q_ENUMS(AuthorizationStatus)

public:
    enum SubscriptionStatus {
        NotSubscribed = 0,
        RemotePending,
        Subscribed
    };

    enum AuthorizationStatus {
        NonExistent = 0,
        LocalPending,
        Authorized
    };

    ~Contact();

    SubscriptionStatus subscriptionStatus() const;
    AuthorizationStatus authorizationStatus() const;
    void subscribe(bool value);
    void authorize(bool value);
    void hideFrom(bool value);
    bool hidingFrom() const;
    void block(bool value);
    bool isBlocked() const;

Q_SIGNALS:
    void subscriptionStatusChanged(QtTapioca::Contact::SubscriptionStatus status);
    void authorizationStatusChanged(QtTapioca::Contact::AuthorizationStatus status);
    void hideFromStatusChanged(bool status);
    void blockStatusChanged(bool status);

private Q_SLOTS:
    void onMembersChangedSubscribe(const QString &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, uint, uint);
    void onMembersChangedPublish(const QString &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, uint, uint);
    void onMembersChangedHide(const QString &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, uint, uint);
    void onMembersChangedAllow(const QString &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, uint, uint);
    void onMembersChangedDeny(const QString &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, const QList<quint32> &, uint, uint);

private:
    friend class ContactList;

    Contact(QtTapioca::Connection * connection,
            org::freedesktop::Telepathy::Connection *telepathyConn,
            org::freedesktop::Telepathy::ConnectionInterfaceAvatars *telepathyIAvatar,
            org::freedesktop::Telepathy::ConnectionInterfacePresence *telepathyIPresence,
            org::freedesktop::Telepathy::ConnectionInterfaceAliasing *telepathyIAliasing,
            org::freedesktop::Telepathy::ConnectionInterfaceCapabilities *telepathyICapabilities,
            org::freedesktop::Telepathy::ChannelInterfaceGroup *telepathyGISubscribe,
            org::freedesktop::Telepathy::ChannelInterfaceGroup *telepathyGIPublish,
            org::freedesktop::Telepathy::ChannelInterfaceGroup *telepathyGIHide,
            org::freedesktop::Telepathy::ChannelInterfaceGroup *telepathyGIAllow,
            org::freedesktop::Telepathy::ChannelInterfaceGroup *telepathyGIDeny,
            Handle *handle,
            QObject *parent = 0);
    void setSubscriptionStatus(SubscriptionStatus status, bool emitSignal = false);
    void setAuthorizationStatus(AuthorizationStatus status, bool emitSignal = false);
    void setHideStatus(bool status, bool emitSignal = false);
    void setBlockStatus(bool status, bool emitSignal = false);
    void setOnGroup(org::freedesktop::Telepathy::ChannelInterfaceGroup *group, bool value);

    ContactPrivate *d;
};

} // namespace

#endif

