/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CHANNEL_TARGET_H
#define QTTAPIOCA_CHANNEL_TARGET_H

#include <QtTapioca/TapiocaExport>

#include <QtCore/QObject>
#include <QtCore/QString>

namespace QtTapioca {

class Handle;
class ChannelTargetPrivate;

class QTTAPIOCA_EXPORT ChannelTarget: public QObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(ChannelTarget)

public:

    ~ChannelTarget();

    Handle *handle() const;
    QString uri() const;

protected:
    ChannelTarget(Handle *handle, QObject *parent = 0);

private:
    ChannelTargetPrivate *d;
};

} // namespace

#endif

