/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2007 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */
#ifndef QTTAPIOCA_AUDIO_STREAM_H
#define QTTAPIOCA_AUDIO_STREAM_H

#include <QtCore/QObject>
#include <QtTapioca/Stream>
#include <QtTelepathy/Client/StreamEngine>
#include <QtTelepathy/Client/Channel_Type_Streamed_Media>

namespace QtTapioca {

class StreamChannel;
class AudioStreamPrivate;

class AudioStream: public Stream {
    Q_OBJECT
    Q_DECLARE_PRIVATE(AudioStream)

public:
    ~AudioStream();

    void setVolume(uint id);
    uint volume() const;
    void muteIn(bool value);
    void muteOut(bool value);

private:
    friend class StreamChannel;

    AudioStream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm, org::freedesktop::Telepathy::StreamEngine *se, uint id, uint contact, uint type, QObject *parent);
    AudioStream(org::freedesktop::Telepathy::ChannelTypeStreamedMedia *sm, org::freedesktop::Telepathy::StreamEngine *se, uint id, uint contact, uint type, uint state, uint direction, uint flags, QObject *parent);
    AudioStreamPrivate *d;
};

} // namespace

#endif

