// This file is part of Eigen, a lightweight C++ template library
// for linear algebra. Eigen itself is part of the KDE project.
//
// Copyright (C) 2006-2007 Benoit Jacob <jacob@math.jussieu.fr>
//
// Eigen is free software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 or (at your option) any later version.
//
// Eigen is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Eigen; if not, write to the Free Software Foundation, Inc., 51
// Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. This exception does not invalidate any other reasons why a work
// based on this file might be covered by the GNU General Public License.

#include "main.h"

template< typename T, int Size, typename MatrixType, typename VectorType >
void helper_checkComparisons()
{
    MatrixType m_rand(Size), m_zero(Size);
    VectorType v_rand(Size), v_zero(Size);
    do m_rand.loadRandom(); while( Util::isNegligible( m_rand(0,0) , static_cast<T>(1) ) );
    m_zero.loadZero();
    do v_rand.loadRandom(); while( Util::isNegligible( v_rand(0) , static_cast<T>(1) ) );
    v_zero.loadZero();
    //QVERIFY( v_zero.isZero() );
    //QVERIFY( m_zero.isZero() );
    QVERIFY( v_zero == v_zero );
    QVERIFY( m_zero == m_zero );
    QVERIFY( v_zero.isApprox( v_zero ) );
    QVERIFY( m_zero.isApprox( m_zero ) );
    QVERIFY( v_rand == v_rand );
    QVERIFY( m_rand == m_rand );
    QVERIFY( v_rand.isApprox( v_rand ) );
    QVERIFY( m_rand.isApprox( m_rand ) );
    QVERIFY( v_rand.isApprox( v_rand * (static_cast<T>(1) + Util::epsilon<T>() / static_cast<T>(100) ) ) );
    QVERIFY( ! v_rand.isApprox( v_rand * (static_cast<T>(1) + Util::epsilon<T>() * static_cast<T>(100) ) ) );
    QVERIFY( v_rand.isApprox( v_rand * (static_cast<T>(1) + Util::epsilon<T>() * static_cast<T>(100) ), Util::epsilon<T>() * static_cast<T>(10000) ) );
    QVERIFY( m_rand.isApprox( m_rand * (static_cast<T>(1) + Util::epsilon<T>() / static_cast<T>(100) ) ) );
    QVERIFY( ! m_rand.isApprox( m_rand * (static_cast<T>(1) + Util::epsilon<T>() * static_cast<T>(100) ) ) );
    QVERIFY( m_rand.isApprox( m_rand * (static_cast<T>(1) + Util::epsilon<T>() * static_cast<T>(100) ), Util::epsilon<T>() * static_cast<T>(10000) ) );
    QVERIFY( v_zero != v_rand );
    QVERIFY( m_zero != m_rand );
    QVERIFY( ! v_zero.isApprox( v_rand ) );
    QVERIFY( ! m_zero.isApprox( m_rand ) );
    QVERIFY( v_zero.isNegligible( v_rand ) );
    QVERIFY( v_zero.isNegligible( v_zero ) );
    QVERIFY( ! v_rand.isNegligible( v_rand ) );
    QVERIFY( v_zero.isNegligible( static_cast<T>(1) ) );
    QVERIFY( v_zero.isNegligible( static_cast<T>(0) ) );
    QVERIFY( ! v_rand.isNegligible( static_cast<T>(1) ) );
}

void MainTest::checkComparisons()
{
#define HELPER_CHECKCOMPARISONS_FIX( T, Size ) \
    helper_checkComparisons< T, Size, \
        Matrix< T, Size >, Vector< T, Size > > ()

#define HELPER_CHECKCOMPARISONS_DYN( T, Size ) \
    helper_checkComparisons< T, Size, \
        MatrixX< T >, VectorX< T > > ()

    for( int repeat = 0; repeat < REPEAT; repeat++ )
    {
        HELPER_CHECKCOMPARISONS_FIX( float, 1 );
        HELPER_CHECKCOMPARISONS_FIX( double, 2 );
        HELPER_CHECKCOMPARISONS_FIX( float, 3 );
        HELPER_CHECKCOMPARISONS_FIX( double, 4 );
        HELPER_CHECKCOMPARISONS_FIX( double, 7 );
        HELPER_CHECKCOMPARISONS_FIX( float, 8 );
        HELPER_CHECKCOMPARISONS_FIX( double, 12 );
        HELPER_CHECKCOMPARISONS_FIX( complex<double>, 7 );
        HELPER_CHECKCOMPARISONS_FIX( complex<float>, 8 );
        HELPER_CHECKCOMPARISONS_FIX( complex<double>, 12 );
    
        HELPER_CHECKCOMPARISONS_DYN( float, 1 );
        HELPER_CHECKCOMPARISONS_DYN( double, 2 );
        HELPER_CHECKCOMPARISONS_DYN( float, 3 );
        HELPER_CHECKCOMPARISONS_DYN( double, 4 );
        HELPER_CHECKCOMPARISONS_DYN( double, 7 );
        HELPER_CHECKCOMPARISONS_DYN( float, 8 );
        HELPER_CHECKCOMPARISONS_DYN( double, 12 );
        HELPER_CHECKCOMPARISONS_DYN( complex<double>, 7 );
        HELPER_CHECKCOMPARISONS_DYN( complex<float>, 8 );
        HELPER_CHECKCOMPARISONS_DYN( complex<double>, 12 );
    }
}
