/*
 * This is a helper library to ease testing of D-Bus objects.
 * Copyright (C) 2008 by Tobias Hunger <tobias@aquazul.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "accountmanagertc.h"

#include <Decibel/DBusNames>
#include <Decibel/AccountManager>
#include <Decibel/AccountData>
#include <Decibel/Errors>

#include <QtCore/QDebug>

AccountManagerTC::AccountManagerTC() { }

AccountManagerTC::~AccountManagerTC() { }

void AccountManagerTC::test_addAccount()
{
    org::kde::Decibel::AccountManager
            account_mgr(Decibel::daemon_service,
                        Decibel::daemon_accountmanager_path,
                        QDBusConnection::sessionBus());

    QVariantMap account_data;
    QDBusReply<quint32> reply(account_mgr.addAccount(account_data));
    QVERIFY2(!reply.isValid(),
             "Received valid reply to addAccount (empty account data).");
    QDBusError error = reply.error();
    qDebug() << "error type:" << error.type()
             << "error name:" << error.name();
    QVERIFY2(error.type() == QDBusError::Other,
             "Wrong error type was returned.");
    QVERIFY2(error.name() == Decibel::ErrorDataIncomplete,
             "Wrong error name was returned.");

    QTest::qWait(15000);
    QList<DBusSignal> dbus_signals = recentSignals();

    QVERIFY2(dbus_signals.isEmpty(), "Received unexpected signals");
}

void AccountManagerTC::test_persistence()
{
    QVariantMap account_data;
    account_data.insert(Decibel::name_protocol, "testproto");
    account_data.insert(Decibel::name_presence, 3);
    account_data.insert(Decibel::name_presence_parameters, QVariantMap());
    account_data.insert(Decibel::name_current_presence, 1);
    account_data.insert(Decibel::name_autoreconnect, false);
    account_data.insert(Decibel::name_display_name, "testproto://unknown@unknown/");
    account_data.insert("name", "value");
    account_data.insert("int", 1);
    account_data.insert("float", 2.0);

    quint32 handle;
    {
        org::kde::Decibel::AccountManager
            account_mgr(Decibel::daemon_service,
                        Decibel::daemon_accountmanager_path,
                        QDBusConnection::sessionBus());
        QDBusReply<quint32> reply(account_mgr.addAccount(account_data));
        QVERIFY2(reply.isValid(), "Received invalid reply to addAccount.");
        handle = reply.value();

        QTest::qWait(1500); // Wait for signals...
        QList<DBusSignal> dbus_signals = recentSignals();

        QVERIFY2(dbus_signals.isEmpty(), "Received unexpected signals");
    }
}

QTEST_MAIN(AccountManagerTC)
