/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2008 George Goldberg <grundleborg@googlemail.com>
 *  @author George Goldberg <grundleborg@googlemail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DECIBEL_DAEMON_COOKIEGENERATOR_H
#define DECIBEL_DAEMON_COOKIEGENERATOR_H

#include <QtCore/QCryptographicHash>

/**
 * @brief Class for generating request cookies.
 * @author George Goldberg <grundleborg@googlemail.com>
 *
 * This class is a singleton. Use CookieGenerator::instance() to get
 * the single application wide instance of it.
 */
class CookieGenerator
{

public: 
    /** @brief Destructor. */
    ~CookieGenerator();

    /**
     * @brief Call this method to get the instance of this singleton class.
     * @return A pointer to the single application-wide instance of this class.
     */
    static CookieGenerator * instance();

    /**
     * @brief Generate a unique cookie for a request.
     * @return The cookie value.
     */
    quint64 getCookie();

private:
    /** @brief Constructor. It is private because this class is a singleton. */
    CookieGenerator();

    /** @brief The actual hash used to generate the cookies. */
    QCryptographicHash * m_generator;
    /** @brief The single instance of CookieGenerator returned by instance(). */
    static CookieGenerator* m_instance;

};

#endif //Header guard
