/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH <info@basyskom.de>
 * Copyright (C) 2008 George Goldberg <grundleborg@googlemail.com>
 *  @author George Goldberg <grundleborg@googlemail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "cookiegenerator.h"

#include <QtCore/QCryptographicHash>
#include <QtCore/QDateTime>

CookieGenerator::CookieGenerator()
 : m_generator(new QCryptographicHash(QCryptographicHash::Sha1))
{
    getCookie();
}

CookieGenerator::~CookieGenerator()
{
    delete m_generator;
    m_instance = 0;
}

CookieGenerator *CookieGenerator::m_instance = 0;

CookieGenerator *
CookieGenerator::instance()
{
    if(m_instance == 0)
    {
        m_instance = new CookieGenerator;
    }
    return m_instance;
}

quint64
CookieGenerator::getCookie()
{
    m_generator->addData(QByteArray::number(QDateTime::currentDateTime().toTime_t()));
    QByteArray hash_result = m_generator->result();
    quint64 cookie = *(reinterpret_cast<const quint64 *>(hash_result.constData()));
    m_generator->addData(hash_result);

    return cookie;
}
