/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2008 George Goldberg <grundleborg@googlemail.com>
 *  @author George Goldberg <grundleborg@googlemail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DECIBEL_PLUGINHELPER_ACCOUNTDATASERIALIZATION_H
#define DECIBEL_PLUGINHELPER_ACCOUNTDATASERIALIZATION_H

#include <Decibel/decibel_pluginhelper_export.h>

#include <QtCore/QByteArray>
#include <QtCore/QVariant>

/**
 * @brief Takes an account data item and serializes it to XML for storage in an
 *        account connector.
 * @param value The QVariant containing the item off account data to serialize.
 * @return The XML representation of the account data item.
 */
DECIBEL_PLUGINHELPER_EXPORT QByteArray serializeAccountDataVariant(const QVariant & value);

/**
 * @brief Takes the XML representation of an account data object and
 *        deserializes it into a QVariant.
 * @param data A byte-array containing the XML representation of the account
 *        data item.
 * @return The resultant QVariant from deserializing the XML received.
 */
DECIBEL_PLUGINHELPER_EXPORT QVariant deserializeAccountDataVariant(const QByteArray & data);

#endif // header guard

