/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DECIBEL_DAEMON_SIMPLISTIC_CONTACTCONNECTOR_H
#define DECIBEL_DAEMON_SIMPLISTIC_CONTACTCONNECTOR_H

#include <contactconnectorbase.h>

#include <QtCore/QList>
#include <QtCore/QVariantMap>

/**
 * @brief This is a implementation of the ContactConnector interface.
 *
 * A simplistic ContactConnector: It reads its data from a QSettings object!
 *
 * @author Tobias Hunger <info@basyskom.de>
 */
class ContactConnector : public ContactConnectorBase
{
    Q_OBJECT
    Q_INTERFACES(ContactConnectorBase)
public:
    /** @brief Constructor. */
    ContactConnector(QObject *parent = 0);

    /** @brief Destructor. */
    ~ContactConnector();

    void openStorage();

    /** @brief ContactConnector::gotContact(...) */
    void gotContact(const QString & contact_url, const quint64 cookie) const;

    /** @brief ContactConnector::contact(...) */
    void contact(const QString & contact_url, const quint64 cookie) const;

    /** @brief ContactConnector::findURI(...) */
    void findURI(const QString & uri, const quint64 cookie) const;

    /** @brief ContactConnector::getURI(...) */
    void getURIs(const QString & contact_url,
                 const QString & proto,
                 const quint64 cookie) const;

    /** @brief ContactConnector::addContact(...) */
    void addContact(const QVariantMap & new_contact, const quint64 cookie);

    /** @brief ContactConnector::setPresence(...) */
    void setPresence(const QString & contact_url, const QString &,
                     const QVariantMap &, const quint64 cookie);

private Q_SLOTS:
    void sendContactDataAvailable();

private:
    /** @brief A list of known contacts (as read from our INI file). */
    QList<QVariantMap> m_contacts;
};

#endif // header guard
