/*
 * A Decibel TextChannel GUI
 * Copyright (C) 2008 George Goldberg <grundleborg@googlemail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "channelhandler.h"

#include "chatwindow.h"

#include <QtCore/QtDebug>

ChannelHandler::ChannelHandler(QObject * parent)
    : Decibel::ChannelHandler(parent)
{
}

ChannelHandler::~ChannelHandler()
{
}

bool ChannelHandler::handleChannel(QtTapioca::Connection * connection,
                                          QtTapioca::Channel *channel,
                                          const bool /* incoming */ )
{
    qDebug() << "handleChannel() called";

    /*
     * we must check if it is a text channel that is received
     */
    QtTapioca::TextChannel *t_channel = dynamic_cast<QtTapioca::TextChannel*>(channel);
    if (t_channel == 0)
    {
        /*
         * not a text channel, so for now, we ignore it.
         */
        qDebug() << "Not a text channel.";
        return false;
    }

    /*
     * it is a text channel, so we launch a new
     * chat window passing the channel and connection
     * to it. The chatwindow will look after itself now.
     */
    new ChatWindow(connection, t_channel);

    return true;
}

