# Try to find the Qt binding of the Tapioca library
# TAPIOCA_QT_FOUND - system has Tapioca-Qt
# TAPIOCA_QT_INCLUDE_DIR - the Tapioca-Qt include directory
# TAPIOCA_QT_LIBRARIES - Link these to use Tapioca-Qt

# Copyright (c) 2008, Allen Winter <winter@kde.org>
#               2008, Tobias Hunger <tobias@aquazul.com>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

SET (DECIBEL_FIND_REQUIRED ${Decibel_FIND_REQUIRED})
if (DECIBEL_INCLUDE_DIR AND DECIBEL_LIBRARIES)
  # Already in cache, be silent
  set(DECIBEL_FIND_QUIETLY TRUE)
endif (DECIBEL_INCLUDE_DIR AND DECIBEL_LIBRARIES)

find_path(DECIBEL_INCLUDE_DIR
          NAMES Decibel/accountdata.h Decibel/accountmanager.h
          PATHS ${CMAKE_INSTALL_PREFIX}/include
)
find_library(DECIBEL_LIBRARIES
             NAMES Decibel
             PATHS ${CMAKE_INSTALL_PREFIX}/lib
)

include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(DECIBEL DEFAULT_MSG
                                  DECIBEL_LIBRARIES DECIBEL_INCLUDE_DIR)


mark_as_advanced(DECIBEL_INCLUDE_DIR DECIBEL_LIBRARIES)

