#!/bin/bash

. ./qemu-kolab-server.conf

QEMU=${QEMU:-qemu}
IMAGE=${IMAGE:-kolab.qcow2}
PORTOFFSET=${PORTOFFSET:-0}
VNCDISPLAY=${VNCDISPLAY:-":0"}
MEM=${MEM:-"256M"}
[ "$SNAPSHOTMODE" == "yes" ] || SNAPSHOTMODE=""
USEDPORTS="22 25 80 143 443 465 993"
MONITOR=${MONITOR:-"stdio"}

rediropts=""
monopts=""

echo "Starting Qemu Kolab Server"

for port in `echo $USEDPORTS "$OMITPORTS" | tr ' ' '\n' | sort -n | uniq -u`
do
  localport=$(( $port + $PORTOFFSET ))
  rediropts="$rediropts -redir tcp:${localport}::${port}"
  echo "forwarding ${localport} => ${port}"
done

if [ "$MONITOR" == "stdio" ] ; then
  monopts="-serial mon:stdio"
elif grep -q '^[0-9]\+$' <<<"$MONITOR" ; then
  monopts="-serial mon:telnet:127.0.0.1:${MONITOR},server,nowait"
fi

echo "Connect to VNC display $VNCDISPLAY for system console."

exec $QEMU -m $MEM ${SNAPSHOTMODE:+"-snapshot"} -vnc $VNCDISPLAY \
  $rediropts \
  $monopts \
  ${LOADVM:+"-loadvm" "$LOADVM"} \
  -hda "$IMAGE"
